#delimit;
capture log close;
set more 1;
clear all;
set mem 300m;
local UNIX 0;
set seed 223883;
* set this to 1 if include 2020 wave;
global INCLUDE2020 1;

*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop";
*global folder "C:\Users\Jeremy\Dropbox";
*global folder "~/";
global folder "D:\Dropbox\";

*global folder "\\ad.ucl.ac.uk\homer\zctpmer\downloads";



         local saved  "$folder\hrs\merge\";
         local trackd "$folder\hrs\tracker\";
         local wave1d "$folder\hrs\wave1\";
         local wave2d "$folder\hrs\wave2\";
         local wave3d "$folder\hrs\wave3\";
         local wave4d "$folder\hrs\wave4\";
         local wave5d "$folder\hrs\wave5\";
		 local wave6d "$folder\hrs\wave6\";
         local wave7d "$folder\hrs\wave7\";
         local wave8d "$folder\hrs\wave8\";
		 local wave9d "$folder\hrs\wave9\";
		 local wave10d "$folder\hrs\wave10\";
		 local wave11d "$folder\hrs\wave11\";
		 local wave12d "$folder\hrs\wave12\";
		 local wave13d "$folder\hrs\wave13\";
		 local wave14d "$folder\hrs\wave14\";
		 local wave15d "$folder\hrs\wave15\";
         local aheadw1 "$folder\hrs\aheadw1\";
         local aheadw2 "$folder\hrs\aheadw2\";


//log using `saved'medcost.log, replace;

*XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX;
*XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXprogram define imputethis;
program define imputethis;

egen recipgrp = group(lowervalue uppervalue);
tab recipgrp;
egen numgroup = max(recipgrp);
local num = numgroup[100];
display `num';

gen exactvalueimpute=.;

*imputation algorithm here*****************************;

local ii =1;
while `ii' <= `num' {;

*first get upper and lower bounds ;
gen mygroup=1;
replace mygroup=0 if recipgrp == `ii';

sum recipgrp if recipgrp == `ii';

sort mygroup;

local mymin= lowervalue[1];
local mymax= uppervalue[1];

qui sum exactvalue if mmiss==0 & exactvalue>=`mymin' & exactvalue<=`mymax' ;
local max = r(N); * number of "donors";

qui sum exactvalue if exactvalue~=. & ((exactvalue>=`mymin' & exactvalue<=`mymax')|(mygroup==0));
local max2 = r(N); *number of "recipients";

gen sortflag = 1;
replace sortflag = 0 if exactvalue~=. & ((exactvalue>=`mymin' & exactvalue<=`mymax')|(mygroup==0));
gen sortflag2 = 1;
replace sortflag2 = 0 if mmiss==0 & exactvalue>=`mymin' & exactvalue<=`mymax' ;

sort sortflag sortflag2  HHID PN; 

	local i=1;
	while `i' <= `max2' {;
	  local i2 = ceil(uniform()*`max');


if (`max'>0 & `max'<999999999) {;
	  qui replace exactvalueimpute = exactvalue[`i2'] in `i';
};
if (`max'<1 |  `max'>999999998) {;
	  qui replace exactvalueimpute = sqrt((lowervalue+10)*uppervalue) in `i';

display `max2';
display `max';
sum mygroup;

};


*};
	  local i = `i' + 1;
	};



drop mygroup sortflag sortflag2;
local ii = `ii' + 1;
};

replace exactvalue=exactvalueimpute if mmiss==1;
replace exactvalue=0 if mmiss==.;
sort mmiss;
by mmiss: sum exactvalue;

drop mmiss recipgrp numgroup exactvalueimpute;


end;

*XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX;
*XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX;



*******************************************************;
* variables I care about                               ;
* iprem = insurance premia                             ;
* drugc = drug costs                                   ;
* oop = out of pocket costs (other than drug costs)    ;
* medcost=oop+drugc+iprem (total med costs paid by hh) ;
* tc= total cost (paid by hh and insurance company for medical services);
*******************************************************;


****N.B.:No imputations for HRS wave 1 AHEAD wave1, need to confirm that hrs total medical variable is equilvalent to out medcost variable; 
*************** WAVE I *****************;
use `wave1d'househld;***N.B. no imputations for wave 1;
gen oop1=.;gen drugc1=.;gen tc1=.;gen medcost1=.;gen iprem1=.;
* only one variable is available - insurance brought by the respondent;
* impute V6638;

destring APN_FIN, replace;
rename APN_FIN PN;

* ins1_1  is premium for private insurance;
gen ins1_1=V6638;
replace ins1_1=0 if V6638==9996; * "INAP" cases = "No" cases for "Do you 
have any insurance bought by yourself?". Therefore, qualifier confirmed 
good enough, using code-book;
replace ins1_1=. if V6639==7; * "other" period case, no such case according to 
codebook;
*comment: here "per other" are coded as missing values, since we don't if it is "per week" or other time periods; 
replace ins1_1=ins1_1*12 if V6639==4; * "month" case;
replace ins1_1=ins1_1*4 if V6639==5; * "quarter" case;

keep HHID PN oop1 drugc1 tc1 iprem1 medcost1 ins1_1;
summ ins1_1;


destring HHID, replace;
sort HHID PN; 
drop if HHID==HHID[_n-1] & PN==PN[_n-1];
sleep 1000; save `saved'medcost, replace; 
use `wave2d'w2r; * NOTE THAT WE ARE USING WAVE2 to impute WAVE1 employer provided health insurance premia; 
*W6705, W6707, W6708, W6709 are you still covered by the same employer health insurance policy as before 1-yes 3-same employer different plan 5-no 6-incorrect 7-not covered 8-don't know 9-refused 0-INAP;

***have to code for change variable - W6716, W6717 cost higher, W6718 cost lower;
gen change=0;
replace change=W6717 if W6717==1|W6717==2;

drop if W6711>99994;
* comment: By doing this, we drop three cases : "other(specify)", "DK" and "RF";

gen ins1_2=W6711*12 if W6705==1|W6707==1|W6708==1|W6709==1;

destring CSUBHH, replace;
rename  CSUBHH W2SUBHH;

destring PN, replace;

destring HHID, replace;

keep HHID PN W2SUBHH ins1_2 change;
sort HHID PN;
merge HHID PN using `saved'medcost;
drop _merge;
drop if HHID==HHID[_n-1] & PN==PN[_n-1];
sort HHID PN;
drop W2SUBHH;

gen indicator1=ins1_1;
gen indicator2=ins1_2;
replace ins1_1=0 if ins1_1==. & indicator2~=.;
replace ins1_2=0 if ins1_2==. & indicator1~=.;
replace ins1_2=. if change~=0;
*drop all the values that have changed, since we don't know what they might be;

* Changed this to make it per year (Phil);
replace iprem1=(ins1_1+ins1_2)/2;

summ;
*replace iprem1=.;


sleep 1000; save `saved'medcost, replace;
drop _all;



********** WAVE 2 **********; 
use `wave2d'medexp2; *Jon: Updated data file does not exist.;
gen tc2=.;
*gen iprem2=.;
*gen medcost2=.;
*This is all totally wrong (Phil);
*gen tc2=totalmed;
*gen medcost2=totaloop;
*sum medcost2 totalexp allins oop tc2;
rename totaloop oop2;
*rename totalexp medcost2;
drop oop;

destring PN, replace;
sort HHID PN;


merge HHID PN using `saved'medcost;
drop _merge;

keep HHID PN iprem* medcost* tc* oop* drugc*;
*summ;

sort HHID PN;
sleep 1000; save `saved'medcost, replace;
*bomb;

clear;







use `wave2d'w2b;



* generate drugc2;
gen drugc2=.;
replace drugc2=W434 if W434<99997; * real amount case;
replace drugc2=. if W434==99997; 
replace drugc2=. if W434==99998|W434==99999;
* replace drugc2=0 if W434==999996; * "INAP" case; 

* Comment: There are about 615 "Other(specify)" cases where W434==99997. 
However, I don't know what is the meaning of this case, by code-book or
Questionnaire. Therefore, I re-coded it as missing;

replace drugc2=. if W433==9; * "RF" case for " Do you regularly buy
prescription?";

replace drugc2=0 if W433==5|W433==8; * "No" and "DK" case for "Do you regularly
buy prescription?", where "DK" is assumed to the same as "NO"; 

replace drugc2=drugc2*52 if W435==2;
replace drugc2=drugc2*12 if W435==4;
replace drugc2=drugc2*2 if W435==7; * From wave 3, I GUESS it means semi-annually paid;
replace drugc2=drugc2*24 if W435==8; * from wave 3, I GUESS it means semi-monthly paid; 

* Li's question???????: there are many 7 & 8 here, which we don't what are meant by. Maybe we should ask HRS;

* comment and questions?????: The re-coding for this variable is not complete.
There is a big mistake in the code-book which prevent me from re-coding this 
Variable. There are cases where W435==7 or W435==8, where the meaning of the 
Value is not explained. At the same time, "DK" and "RF" cases are missing for
W435;

destring HHID, replace;
keep HHID PN drugc2;
summ;
sort HHID PN; 
drop if HHID==HHID[_n-1] & PN==PN[_n-1];
summ HHID PN;

sort HHID PN; 
sleep 1000; save `saved'temp2, replace; 

drop _all;


********* WAVE 2 INSURANCE ***********;

*************** wave 2 is clear of any positive insurance cost problem;

use `wave2d'w2r;

* employer provided health insurance;
gen ins2_1=.;
replace ins2_1=W6711*12 if W6711<99994; 
replace ins2_1=0 if W6705==5|W6705==7|W6705==8|W6707==5|W6707==8|W6709==5|W6709==6|W6709==7|W6709==8;
replace ins2_1=. if W6705==9|W6707==9|W6709==9;


* change to the following:;
* gen ins2_1=.;
* replace ins2_1=W6711*12 if W6711<99994;


gen ins2_2=.;
replace ins2_2=W6728*12 if W6728<994;
replace ins2_2=0 if W6716==5|W6716==8|W6724==5|W6724==8|W6727==8;
replace ins2_2=. if W6716==9|W6724==9|W6727==9; 

gen ins2_3=.;
replace ins2_3=W6742*12 if W6742<994;
replace ins2_3=0 if W6716==5|W6716==8|W6716==9|W6724==5|W6724==8|W6741==8;
replace ins2_3=. if W6716==9|W6724==9|W6741==9; 

*purchased directly from insurance company;
gen ins2_4=.;
replace ins2_4 = W6755*12 if W6756 == 4 & W6755<99994;
replace ins2_4 = W6755*4 if W6756 == 5 & W6755<99994;
replace ins2_4 = W6755 if W6756 == 6 & W6755<99994;
replace ins2_4 = 0 if W6754==5|W6754==8|W6754==0;
replace ins2_4=. if W6754==9; 
*W6754 do you have any basic health insurance plan purchased directly;

gen ins2_5=.;
replace ins2_5 = W6762*12 if W6763 == 4 & W6762<99994;
replace ins2_5 = W6762*4 if W6763 == 5 & W6762<99994;
replace ins2_5 = W6762 if W6763 == 6 & W6762<99994; 
replace ins2_5=0 if W6757==5|W6757==8|W6757==0;
replace ins2_5=. if W6757==9;


replace ins2_5 = 0 if ins2_5==. & (W6757==5|W6757==0);
*W6757 do you have any type of supplementary health insurance coverage;

summ ins2_1-ins2_5;

gen iprem2=ins2_1+ins2_2+ins2_3+ins2_4+ins2_5;


destring HHID, replace;
keep HHID PN iprem2 ins* ;
sort HHID PN;
merge HHID PN using `saved'temp2;
drop _merge;


summ;

destring PN, replace;

sort HHID PN;
merge HHID PN using `saved'medcost;
drop _merge;
sort HHID PN;

drop if HHID==HHID[_n-1] & PN==PN[_n-1];
sort HHID PN;


*keep HHID PN iprem* medcost* tc*;
summ;


gen medcost2 = oop2 + drugc2 + iprem2;

sort HHID PN;
sleep 1000; save `saved'medcost, replace;
clear;
*bomb;

*save `saved'medcost, replace;
*drop _all;














***********WAVE 3*********;
use `wave3d'h96cs_r;
keep HHID PN;
sort HHID PN;
sleep 1000; save `saved'temp2, replace;

use `wave3d'H96i_er;
sort HHID PN;
merge HHID PN using `saved'temp2;
drop _merge;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

sort HHID PN;
merge HHID PN using `saved'medcost;
drop _merge;



***OOP Annual Expenses******;
gen hospc3=E1783X/2; *imputed oop hospital or nursing home costs;
gen docc3=E1804X/2; *imputed oop E18A.DOCTOR/OUT/DENTAL R PAY $;
gen drugc3=(E1816X*12); *imputed oop rx drug costs;
gen othels3=E1834X/2; *imputed oop amt. other health services;

gen oop3=hospc3+docc3+othels3;
gen tc3=E1841X; *"E26.TOTAL COST MEDICAL";


*sum hospc3 docc3 drugc3 othels3 medcost3 tc3;
keep HHID ESUBHH PN medcost*  oop* hospc* docc* drugc* othels* tc* iprem* ;
summ;
sort HHID PN;
sleep 1000; save `saved'medcost, replace;
drop _all;
*bomb;

*insurance;
* infile using `wave3d'H96R_R.DCT;
use `wave3d'H96R_R;
gen temp1=real(HHID);
gen temp2=real(PN);
drop if temp1==78581 & temp2==20;
drop temp1 temp2;


* cost of Medicare through HMO;
gen ins3_1=.;
replace ins3_1=E5152 if E5152~=. & E5152<9997;
replace ins3_1=. if E5153~=. & E5153>4;
*E5153 is variable for per (month, year, etc.);
replace ins3_1=0 if E5133==5|E5133==8;
replace ins3_1=. if E5133==9|E5133==.;
replace ins3_1=0 if E5148==5|E5148==8;
replace ins3_1=. if E5148==9;
* the above qualifiers are confirmed correct, by logically sorting out the questionnaire; 
* E5146=3 for those not covered by MEDCARE or MEDCAID;
* E5133==5|E5133==8|E5133==9 are "no" and "DK" and "refused" cases;
* E5133 covered by medicare (medicaid the respondent doesn't have to pay for, so the cost is automatically zero - we're interested only in whether covered by medicare;

replace ins3_1=ins3_1*12 if E5153==1;
replace ins3_1=ins3_1*4 if E5153==2;
replace ins3_1=ins3_1*2 if E5153==3;

* costs of employer provided insurance;
gen ins3_2=.;
replace ins3_2=E5167_1 if E5167_1~=. & E5167_1<9997;

summ ins3_2 E5167_1;

replace ins3_2=ins3_2*4 if E5168_1==2;
replace ins3_2=ins3_2*6 if E5168_1==3;
replace ins3_2=ins3_2*12 if E5168_1==4;
replace ins3_2=ins3_2*52 if E5168_1==5;
summ ins3_2;
replace ins3_2=ins3_2*26 if E5168_1==6;
summ ins3_2;
replace ins3_2=ins3_2*2 if E5168_1==7;
summ ins3_2;
replace ins3_2=ins3_2*24 if E5168_1==8;
summ ins3_2;

replace ins3_2=. if E5168_1==97|E5168_1==98|E5168_1==99;
* Note: E5168_1==97|E5168_1==98|E5168_1==9 refers to "other(specify)",
"DK" or "RF" cases for payment periods;

replace ins3_2=0 if E5160==5|E5160==8;
replace ins3_2=. if E5160==9;
replace ins3_2=0 if E5166_1==3;
replace ins3_2=. if E5166_1==8|E5166_1==9;
replace ins3_2=0 if E5165_1==1; 
* replace ins3_2=0 if ins3_2==. & E5157==1;
* replace ins3_2=0 if ins3_2==. & E5158==1;
*E5157 self-employed;
*E5160 are you covered through employer provided insurance, 5=no;
*E5166_1 do you pay 1.all, 2.some, 3.none of the costs of this health insurance;
summ ins3_2;

gen ins3_3=.;
replace ins3_3=E5167_2 if E5167_2~=. & E5167_2<9997;
replace ins3_3=0 if E5161==1; * only one employer-provided insurance; 

replace ins3_3=ins3_3*4 if E5168_2==2;
replace ins3_3=ins3_3*6 if E5168_2==3;
replace ins3_3=ins3_3*12 if E5168_2==4;
replace ins3_3=ins3_3*52 if E5168_2==5;
summ ins3_3;
replace ins3_3=ins3_3*26 if E5168_2==6;
summ ins3_3;
replace ins3_3=ins3_3*2 if E5168_2==7;
summ ins3_3;
replace ins3_3=ins3_3*24 if E5168_2==8;
summ ins3_3;

replace ins3_3=. if E5168_2==97|E5168_2==98|E5168_2==99;
* Note: E5168_2==97|E5168_2==98|E5168_2==9 refers to "other(specify)",
"DK" or "RF" cases for payment periods;

replace ins3_3=0 if E5160==5|E5160==8;
replace ins3_3=. if E5160==9;
replace ins3_3=0 if E5166_2==3;
replace ins3_3=. if E5166_2==8|E5166_2==9;
replace ins3_3=0 if E5165_2==1; 
* replace ins3_3=0 if ins3_3==. & E5157==1;
* replace ins3_3=0 if ins3_3==. & E5158==1;
* E5157 self-employed;
* E5160 are you covered through employer provided insurance, 5=no;
* E5166_2 do you pay 1.all, 2.some, 3.none of the costs of this health insurance;
summ ins3_3;


************************** deactivate the following re-coding;
* replace ins3_3=0 if ins3_3==. & (E5160==5|E5160==8|E5166_1==3|E5166_2==3);
* replace ins3_3=. if E5167_2>9996 & E5167_2~=.;

* summ ins3_3 E5167_2;

* replace ins3_3=ins3_3*4 if E5168_2==2;
* replace ins3_3=ins3_3*6 if E5168_2==3;
* replace ins3_3=ins3_3*12 if E5168_2==4;
* replace ins3_3=ins3_3*52 if E5168_2==5;
* replace ins3_3=ins3_3*26 if E5168_2==6;
* replace ins3_3=ins3_3*2 if E5168_2==7;
* replace ins3_3=ins3_3*24 if E5168_2==8;
* replace ins3_3=. if E5168_2==97|E5168_2==98|E5168_2==99;
* Note: E5168_2==97|E5168_2==98|E5168_2==9 refers to "other(specify)",
"DK" or "RF" cases for payment periods;
************************************************;



summ ins3_1-ins3_3;

* Supplemental coverage;
gen ins3_4=.;
replace ins3_4=E5209 if E5209~=. & E5209<999998 & E5210<97 & E5210~=.;
replace ins3_4=0 if E5205==2; * for those not belonging to "R IS COVERED BY
MEDICARE AND NO MEDIGAP INSURANCE";
replace ins3_4=0 if E5206==5|E5206==8; * "No" and " DK" for E5206;
replace ins3_4=. if E5206==9;
replace ins3_4=0 if E5208==3; * "none" payment for the cost of this insurance;
replace ins3_4=. if E5208==8|E5208==9;

summ ins3_4 E5209;

replace ins3_4=ins3_4*4 if E5210==2;
replace ins3_4=ins3_4*6 if E5210==3;
replace ins3_4=ins3_4*12 if E5210==4;
replace ins3_4=ins3_4*52 if E5210==5;
replace ins3_4=ins3_4*26 if E5210==6;
replace ins3_4=ins3_4*2 if E5210==7;
replace ins3_4=ins3_4*24 if E5210==8; * no such case according to code-book;
replace ins3_4=. if E5210==97|E5210==98|E5210==99; * no such case;

summ ins3_4;

*Private/AARP/professional coverage;
gen ins3_5=.;
replace ins3_5=E5221 if E5221~=. & E5221<999997 & E5222<97 & E5222~=.;

summ ins3_5 E5221;

replace ins3_5=ins3_5*4 if E5222==2;
replace ins3_5=ins3_5*6 if E5222==3;
replace ins3_5=ins3_5*12 if E5222==4;
replace ins3_5=ins3_5*52 if E5222==5;
replace ins3_5=ins3_5*26 if E5222==6;
replace ins3_5=ins3_5*2 if E5222==7;
replace ins3_5=ins3_5*24 if E5222==8;
replace ins3_5=0 if E5133==1|E5136==1|E5145==1|E5160==1; 
*E5133 "covered" by "medicare" already;
*E5136 covered by medicaid already;
*E5145 covered by veteran insurance already;
*E5160 covered by employer provided already;
replace ins3_5=0 if E5218==5|E5218==8; * "no" and "DK" for E5218;
replace ins3_5=. if E5218==9;
replace ins3_5=0 if E5219==5|E5219==8; * 21 cases.;
replace ins3_5=. if E5219==9;
replace ins3_5=0 if E5220==3; * "none" payment for this insurance;
replace ins3_5=. if E5220==8|E5220==9; 

summ ins3_5;

******************* 11 observations with long-term insurance, while we don't know where such insurance comes from *********************;

*amount pay for long term care;
gen ins3_6=0;
replace ins3_6=E5270 if E5270~=. & E5270<999995 & E5271~=. & E5271<7;
replace ins3_6=0 if E5270==999995; * included in insurance, not paid separately;
replace ins3_6=. if E5270==999997|E5270==999998|E5270==999999;
replace ins3_6=0 if E5266==5|E5266==8;
replace ins3_6=. if E5266==9;
replace ins3_6=ins3_6*4 if E5271==2;
replace ins3_6=ins3_6*52 if E5271==3;
replace ins3_6=ins3_6*12 if E5271==4;


summ ins*;
gen iprem3=ins3_1+ins3_2+ins3_3+ins3_4+ins3_5+ins3_6;

*going to drop a value that looks like an outlier, compared to other insurance premiums;
replace iprem3=. if (iprem3>119000 & iprem3~=.);
*gets rid of iprem3 in Observation 9740, which was 1,000,118, compared to iprem2=0, iprem4=120, iprem5=1008;
summ iprem3;

gen temp2 = real(HHID);
drop HHID;
rename temp2 HHID;
gen temp2 = real(PN);
drop PN;
rename temp2 PN;
keep iprem3 ins* HHID PN;
sort HHID PN;
merge HHID PN using `saved'medcost;
drop _merge;

gen medcost3 = oop3 + drugc3 + iprem3;

sort HHID PN;
sleep 1000; save `saved'medcost, replace;
*bomb;

drop _all;

**trying for TC3;
use `wave3d'H96E_R;
gen tc3 = E1841 if E1841 < 9999997;
replace tc3 = 1000 if E1843 == 1 & tc3 == .;
replace tc3 = 500 if E1843 == 2 & tc3 == .;
replace tc3 = 5000 if E1842 == 1;
replace tc3 = 3000 if E1842 == 2 & E1843 == 1;
replace tc3 = 25000 if E1844 == 1;
replace tc3 = 15000 if E1844 == 2 & E1842 == 1;
replace tc3 = 100000 if E1845 == 1;
replace tc3 = 62500 if E1845 == 2 & E1844 == 1;
replace tc3 = 500000 if E1846 == 1;
replace tc3 = 300000 if E1846 == 2 & E1845 == 1;
sum tc3;
*bomb;
clear;




***** WAVE4 ******;
use `wave4d'h98pr_r;
keep F122_1 HHID PN;
sort HHID PN;
merge HHID PN using `saved'temp2;
drop _merge;
sort HHID PN;
sleep 1000; save `saved'temp2, replace;


use `wave4d'h98i_er;
sort HHID PN;
merge HHID PN using `saved'temp2;
drop _merge;

gen  temp=real(HHID);
drop HHID;
rename temp HHID;
*recast double HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

sort HHID PN;
merge HHID PN using `saved'medcost;
drop _merge;


***OOP Annual Expenses******;
gen hospc4=F2305X/2; *imputed oop hospital or nursing home costs;
gen docc4=F2337X/2; *imputed oop E18A.DOCTOR/OUT/DENTAL R PAY $;
gen drugc4=(F2347X*12); *imputed oop rx drug costs;
gen othels4=F2364X/2; *imputed oop amt. other health services;

gen oop4=hospc4+docc4+othels4;
*gen medcostx4=MDCOST_X; *"E26.TOTAL COST MEDICAL"; *Turns out this is blank;
gen tc4 = (MDCOST_D+MDCOST_E)/2;

*bomb;
*sum hospc4 docc4 drugc4 othels4 medcostx4 ;

keep HHID PN medcost*  oop* hospc* docc* drugc* othels* tc* iprem* doc* ins3_1;
summ;
sort HHID PN; 
sleep 1000; save `saved'medcost, replace;
drop _all;
*bomb;










***INSURANCE;
use `wave4d'h98r_r; 
gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;

* This is the same as R11B from Wave 3 - "The Amount Paid for Plan";
* These are the Medicare costs;
* impute F5885;
gen ins4_1=.;
replace ins4_1=F5885 if F5885~=. & F5885<9998 & F5886<7 & F5886~=.;
* replace ins4_1=0 if F5879==2|F5879==3;
replace ins4_1=0 if F5866==5|F5866==8;
replace ins4_1=. if F5866==9;
replace ins4_1=. if F5879==.; * partial interviews;
replace ins4_1=0 if F5881==5|F5881==8;
replace ins4_1=. if F5881==9; * "RF" case for F5881; 
replace ins4_1=ins4_1*12 if F5886==1;
replace ins4_1=ins4_1*4 if F5886==2;
replace ins4_1=ins4_1*2 if F5886==3;
replace ins4_1=. if F5886~=. & F5886>4;

* Costs of employer provided Insurance;
* impute F5900;

gen ins4_2=.;
replace ins4_2=F5900 if F5900~=. & F5900<9998 & F5901<97 & F5901~=.;
replace ins4_2=0 if F5893==5|F5893==8;
replace ins4_2=. if F5893==9;
replace ins4_2=0 if F5898==1;
replace ins4_2=0 if F5899==3;
replace ins4_2=. if F5899==8|F5899==9;
replace ins4_2=ins4_2*4 if F5901==2;
replace ins4_2=ins4_2*6 if F5901==3;
replace ins4_2=ins4_2*12 if F5901==4;
replace ins4_2= ins4_2*52 if F5901==5;
replace ins4_2= ins4_2 if F5901==6;
replace ins4_2= ins4_2*2 if F5901==7;
replace ins4_2=ins4_2*24 if F5901==8;





*Supplemental Coverage;
*In Wave4: "Other Insurance";
* impute F5941;
gen ins4_3=.;
replace ins4_3=F5941 if F5941~=. & F5941<999998 & F5942<=97 & F5942~=.;

**** the following three cases are substitutions for F5937==2;
replace ins4_3=0 if F5866==5|F5866==8;
replace ins4_3=. if F5866==9;
replace ins4_3=0 if F5903==1;
*******;

replace ins4_3=0 if F5938==5|F5938==8;
replace ins4_3=. if F5938==9;
replace ins4_3=0  if F5940==3;
replace ins4_3=. if F5940==8|F5940==9;
replace ins4_3=. if F5937==.; * partial interviews;
replace ins4_3=. if F5941==999998|F5941==999999|F5942==97|F5942==98|F5942==99;
replace ins4_3= ins4_3*4 if F5942==2;
replace ins4_3= ins4_3*6 if F5942==3;
replace ins4_3= ins4_3*12 if F5942==4;
replace ins4_3= ins4_3*52 if F5942==5;
replace ins4_3= ins4_3*26 if F5942==6;
replace ins4_3= ins4_3*2 if F5942==7;
replace ins4_3= ins4_3*24 if F5942==8;

* Private/AARP/Professional Coverage;
* impute F5953;
gen ins4_4=0;
replace ins4_4=F5953 if F5953~=. & F5953<999998 & F5954<97 & F5954~=.;
replace ins4_4=0 if F5866==1|F5869==1|F5878==1|F5893==1;
replace ins4_4=0 if F5950==5|F5950==8;
replace ins4_4=. if F5950==9;

* note that some missing will happen here because F5952 is not recorded in the data set;

replace ins4_4= ins4_4*4 if F5954==2;
replace ins4_4= ins4_4*6 if F5954==3;
replace ins4_4= ins4_4*12 if F5954==4;
replace ins4_4= ins4_4*52 if F5954==5;
replace ins4_4= ins4_4*26 if F5954==6;
replace ins4_4= ins4_4*2 if F5954==7;
replace ins4_4= ins4_4*24 if F5954==8;



******************* 15 observations with long-term insurance, while we don't know where such insurance comes from *********************;

*long term insurance;
gen ins4_5=.;
replace ins4_5=F6003 if F6003~=. & F6003<999998 & F6004~=. & F6004<7;
replace ins4_5=0 if F6003==0; * very subtle one;
replace ins4_5=0 if F5999==5|F5999==8;
replace ins4_5=. if F5999==9;
replace ins4_5=ins4_5*4 if F6004==2;
replace ins4_5=ins4_5*52 if F6004==3;
replace ins4_5=ins4_5*12 if F6004==4;

sum ins4_*;




gen iprem4=ins4_1+ ins4_2+ ins4_3+ ins4_4+ins4_5;
* replace iprem4=0 if F5970==2; * This is not correct, because iprem4 includes premium for long-term insurance;
* replace iprem4=. if F5970==.; * This is not correct, because iprem4 includes premium for long-term insurance;


keep iprem4 HHID PN ins*;
sort HHID PN;
merge HHID PN using `saved'medcost;
drop _merge;

gen medcost4 = oop4 + iprem4 + drugc4;

sort HHID PN;
sleep 1000; save `saved'medcost, replace;
clear;








*************Wave5****************;
use `wave5d'H00PR_R; *Jon: Multiple updated files possible, others are H00PR_R, H00PR_SB if this one doesn't work.;
sort HHID PN;

renpfix G Q;
keep Q122 HHID PN;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

merge HHID PN using `saved'medcost;
drop _merge;
sort HHID PN;
sleep 1000; save `saved'temp2, replace;

use `wave5d'h00i_er;
sort HHID PN;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

merge HHID PN using `saved'temp2;
drop _merge;

***OOP Annual Expenses******;
gen hospc5=G2577X/2; *imputed oop hospital or nursing home costs;
gen docc5=G2614X/2; *imputed oop E18A.DOCTOR/OUT/DENTAL R PAY $;
gen drugc5=(G2624X*12); *imputed oop rx drug costs;
gen othels5=G2641X/2; *imputed oop amt. other health services;

gen oop5=hospc5+docc5+othels5;

*gen medcostx5=MDCOST_X; *"E26.TOTAL COST MEDICAL"; *Turns out this is blank;
*replace MDCOST_D = 0 if MDCOST_D == .;
*replace MDCOST_E = 0 if MDCOST_E == .;
replace MDCOST_D=1000 if (MDCOST_D==0|MDCOST_D==.) & MDCOST_E~=.;

gen tc5a = (MDCOST_D+MDCOST_E)/2;
gen tc5b = sqrt(MDCOST_D*MDCOST_E);

sum MDCOST_D MDCOST_E tc*;

gen tc5=tc5b;
replace tc5 = 0 if tc5 == .;

*sum hospc5 docc5 drugc5 othels5 medcostx5 tc5;

keep HHID PN medcost*  oop* hospc* docc* drugc* othels* tc* iprem* doc* ins*;
summ;
sort HHID PN;
sleep 1000; save `saved'medcost, replace;
drop _all;









***INSURANCE;
use `wave5d'H00R_R;
* This is the same as R11B from Wave 3 & Wave 4;
* These are the Medicare costs;
* impute Q6258;
* Q6258 is the insurance premium on medicare/medicaid through HMO;

renpfix G Q;
gen ins5_1=.;

replace ins5_1=0 if Q6238==5|Q6238==8;
replace ins5_1=. if Q6238==9;
replace ins5_1=0 if Q6254==5|Q6254==8;
replace ins5_1=. if Q6254==9;
replace ins5_1=Q6258 if Q6258~=. & Q6258<9998 & Q6259~=. & Q6259<7;
replace ins5_1=ins5_1*12 if Q6259 == 1;
replace ins5_1=ins5_1*4 if Q6259 == 2;
replace ins5_1=ins5_1*2 if Q6259 == 3;
replace ins5_1=0 if ins5_1==.;

***********  Costs of employer provided Insurance *************;
* impute Q6273;
replace Q6273=0 if Q6264==1|Q6266==5|Q6266==8|Q6271==1|Q6272==3;
replace Q6273=. if Q6266==9; * "RF" for Q6266;
replace Q6273=. if Q6272==8|Q6272==9; * changed; 
replace Q6273=. if (Q6273~=. & Q6273>9996)|(Q6274>96 & Q6274~=.);


gen ins5_2=Q6273;
replace ins5_2=ins5_2*4 if Q6274==2;
replace ins5_2=ins5_2*6 if Q6274==3;
replace ins5_2=ins5_2*12 if Q6274==4;
replace ins5_2=ins5_2*52 if Q6274==5;
replace ins5_2=ins5_2*26 if Q6274==6;
replace ins5_2=ins5_2*2 if Q6274==7;
replace ins5_2=ins5_2*24 if Q6274==8;
replace ins5_2=0 if ins5_2==.;


********************* Supplemental Coverage *************** ;
** In Wave4 & Wave5: "Other Insurance";

* impute Q6315;

replace Q6315=0 if Q6238==5|Q6238==8; 
replace Q6315=. if Q6238==9; 
*replace Q6315=0 if Q6276==1; * Yes for Q6276; * Remarked out by Phil after talking to Eric, but this is a @FLAG!;
* note the above three commands corresponds to Q6311==1, but I think these three commands are more accurate than Q6311==1, which may convert too many missing into 0;
*replace Q6315=0 if Q6312==5|Q6312==8|; *this portion is remarked out by Phil after talking to Eric, but this is a @FLAG!;
replace Q6315=0 if Q6314==3; * qualifiers confirmed by code-book;
replace Q6315=. if Q6312==9|Q6314==8|Q6314==9;
replace Q6315=. if (Q6315~=. & Q6315>999996)|(Q6316>96 & Q6316~=.);

gen ins5_3=Q6315;
replace ins5_3=ins5_3*4 if Q6316==2;
replace ins5_3=ins5_3*6 if Q6316==3;
replace ins5_3=ins5_3*12 if Q6316==4;
replace ins5_3=ins5_3*52 if Q6316==5;
replace ins5_3=ins5_3*26 if Q6316==6;
replace ins5_3=ins5_3*2 if Q6316==7;
replace ins5_3=ins5_3*24 if Q6316==8;
replace ins5_3=0 if ins5_3==.;


*********   Private/AARP/Professional Coverage   ************;


gen ins5_4=.;
*replace ins5_4=0 if Q6238==1;
*replace ins5_4=0 if Q6324==5|Q6324==8;
*replace ins5_4=. if Q6324==9;
*replace ins5_4=0 if Q6325==5|Q6325==8;
*replace ins5_4=. if Q6325==9;
* The above lines were removed for many reasons.  First, they are clearly miscoded;
* second, their intended effect is no longer desired.  also, this is a @FLAG!;

replace ins5_4=Q6327 if Q6327~=. & Q6327<999997 & Q6328~=. & Q6328<97;
replace ins5_4=ins5_4*4 if Q6328==2;
replace ins5_4=ins5_4*6 if Q6328==3;
replace ins5_4=ins5_4*12 if Q6328==4;
replace ins5_4=ins5_4*52 if Q6328==5;
replace ins5_4=ins5_4*26 if Q6328==6;
replace ins5_4=ins5_4*2 if Q6328==7;
replace ins5_4=ins5_4*24 if Q6328==8;
replace ins5_4=0 if ins5_4==.;


********************* the following re-coding is misled by the code-book*******;
* replace Q6327=0 if Q6327==.;
* replace Q6327=. if Q6324==9|Q6325==9;

* replace Q6327=0 if Q6327==.|Q6328==.; * By this, we may convert true missing
values into 0 values. I don't think this is justified;

* replace Q6327=. if Q6327>999996|(Q6328>96 & Q6328~=.);
* gen ins5_4=Q6327;
* replace ins5_4=ins5_4*4 if Q6328==2;
* replace ins5_4=ins5_4*6 if Q6328==3;
* replace ins5_4=ins5_4*12 if Q6328==4;
* replace ins5_4=ins5_4*52 if Q6328==5;
* replace ins5_4=ins5_4*26 if Q6328==6;
* replace ins5_4=ins5_4*2 if Q6328==7;
* replace ins5_4=ins5_4*24 if Q6328==8;
*******************************************************************************;




*****************   11 observations with long-term care insurance, while we don't know where such insurance comes from ***************;

gen ins5_5=.;
replace ins5_5=0 if Q6393==5|Q6393==8;
replace ins5_5=. if Q6393==9;
replace ins5_5=Q6397 if Q6397~=. & Q6397<999995 & Q6398~=. & Q6398<7; * a few people report 999995 -- hrs says actual value, but implausible;
replace ins5_5=ins5_5*4 if Q6398==2; 
replace ins5_5=ins5_5*12 if Q6398==4;
replace ins5_5=0 if ins5_5==.;


*ins5_1 is the medicare costs;
*ins5_2 is Cost of Employer provided Coverage;
*ins5_3 is Supplemental Coverage;
*ins5_4 is Professional Coverage;
*ins5_5 is Long Term Coverage;
sum ins5_*;

rename QSUBHH GSUBHH;

gen iprem5=ins5_1+ ins5_2+ ins5_3+ ins5_4+ins5_5;
sum iprem5 ins5_1  ins5_2  ins5_3  ins5_4 ins5_5;
*exit;


gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
keep HHID GSUBHH PN iprem5 ins*;
sort HHID PN;
merge HHID PN using `saved'medcost;
drop _merge;

gen medcost5 = oop5 + drugc5 + iprem5;

sort HHID PN;
sleep 1000; save `saved'medcost, replace;


clear;





*********************Wave VI***********************;
use `wave6d'h02i_nr;
sort HHID PN;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

merge HHID PN using `saved'medcost;
drop _merge;

***OOP Annual Expenses******;
gen hospc6=HN106X/2; *imputed oop hospital costs;
gen nursc6=HN119X/2; *imputed oop nursing home costs;
gen outsgc6=HN139X/2; *imputed oop outpatient surgery costs;
gen docc6=HN156X/2; *imputed oop doctor visits costs;
gen dentc6=HN168X/2; *imputed oop dental costs;
gen drugc6=(HN180X*12); *imputed oop rx drug costs;
gen hhsc6=HN194X/2; *imputed oop home health service costs;
gen othels6=HN239X/2; *imputed oop amt. other health services;
gen oop6=hospc6+nursc6+outsgc6+docc6+dentc6+hhsc6+othels6;
*gen oop6b = hospc6+docc6+othels6;
*gen oop6c = hospc6+docc6+othels6+outsgc6;
*gen oop6 = hospc6+docc6+othels6+outsgc6+nursc6+hhsc6;





gen ins6_1a=HN014X; *imputed MEDICARE/MEDICAID HMO-AMT PAY;
gen ins6_2a=HN040_1X; *imputed PRIV PLAN HI PAY PER/MONTH- AMT- 1;
gen ins6_3a=HN040_2X; *imputed PRIV PLAN HI PAY PER/MONTH- AMT- 2;
gen ins6_4a=HN040_3X; *imputed PRIV PLAN HI PAY PER/MONTH- AMT- 3;
gen ins6_5a=HN079X; *imputed AMT PAY FOR LTC;
replace ins6_1a = 0 if ins6_1a == .;
replace ins6_2a = 0 if ins6_2a == .;
replace ins6_3a = 0 if ins6_3a == .;
replace ins6_4a = 0 if ins6_4a == .;
replace ins6_5a = 0 if ins6_5a == .;
replace ins6_1a = ins6_1a*12;
replace ins6_2a = ins6_2a*12;
replace ins6_3a = ins6_3a*12;
replace ins6_4a = ins6_4a*12;
replace ins6_5a = ins6_5a;

gen iprem6a = ins6_1a + ins6_2a + ins6_3a + ins6_4a + ins6_5a;
*sum hospc6 nursc6 outsgc6 docc6 dentc6 drugc6 hhsc6 othels6 tc6 medcarex6  ins6_1 ins6_2 ins6_3 ins6_4 ltc6;
*bomb;
keep HHID PN medcost*  oop* hospc* dentc* docc* drugc* othels* nursc* outsgc* hhsc* tc* iprem* ins*;
*drop iprem6;
summ;
gen medcost6a = oop6 + iprem6a + drugc6;
sort HHID PN;
sleep 1000; save `saved'medcost, replace; 
clear;

use `wave6d'H02N_R;
gen tc6a = (HN222 + HN223)/2;
gen tc6b = sqrt(HN222*HN223);
gen tc6=tc6b;
sum tc6*;

********************** impute ins6_1 using brackets ***********;

replace HN014 = HN014/3 if HN018 == 2;
replace HN014 = HN014/6 if HN018 == 3;
replace HN014 = HN014/12 if HN018 == 4;
replace HN014 = . if HN018>4 & HN018~=.;

replace HN016=2401 if HN016==1200;

gen mmiss=.;
replace mmiss=0 if HN014>-100 & HN014<9991;
replace mmiss=1 if HN014>9990 & HN014<199999999;

gen exactvalue=HN014;
gen lowervalue=HN015;
gen uppervalue=HN016;




imputethis;
gen ins6_1 = exactvalue * 12;
replace ins6_1=0 if ins6_1==.; //what to if HN014<9990 & HN018>4? Here ins6_1=0 in that case;

/*
gen ins6_1 = HN014;
replace ins6_1 = . if HN014 > 9997;
egen mymin=min(HN016/5) if (HN016~=0 & HN016~=.);
replace HN015=mymin if HN015==0; drop mymin;
replace ins6_1=sqrt(HN015*HN016) if (HN015~=. & HN016~=.);
sum HN014 HN015 HN016 ins6_1;


replace ins6_1 = ins6_1*12 if HN018 == 1;
replace ins6_1 = ins6_1*4 if HN018 == 2;
replace ins6_1 = ins6_1*2 if HN018 == 3;
replace ins6_1 = . if HN018 > 4;
replace ins6_1 = 0 if ins6_1 == .;
*/

********************** impute ins6_2 using brackets ***********;


replace HN042_1 = 990 if HN042_1==1500;

gen mmiss=.;
replace mmiss=0 if HN040_1>-100 & HN040_1<991;
replace mmiss=1 if HN040_1>990 & HN040_1<19990;

replace exactvalue=HN040_1;
replace lowervalue=HN041_1;
replace uppervalue=HN042_1;

imputethis;
gen ins6_2 = exactvalue*12;
replace ins6_2=0 if ins6_2==.;

/*
gen ins6_2 = HN040_1;
replace ins6_2 = . if ins6_2 > 997;
egen mymin=min(HN042_1/5) if (HN042_1~=0 & HN042_1~=.);
replace HN041_1=mymin if HN041_1==0; drop mymin;
replace ins6_2=sqrt(HN041_1*HN042_1) if (HN041_1~=. & HN042_1~=.);
sum ins6_2 if HN040_1~=0 & HN040_1~=.;
sum ins6_2 if HN041_1~=. & HN042_1~=.;

replace ins6_2 = sqrt(HN041_1*HN042_1) if ins6_2 == .;
replace ins6_2 = 0 if ins6_2 == .;
replace ins6_2 = ins6_2*12;

*replace ins6_2 = 0 if HN033_1 == 1;
*replace ins6_2 = 0 if HN035_1 == 1;
replace ins6_2 = 0 if HN039_1 == 3;
*/

********************** impute ins6_3 using brackets ***********;
replace HN042_2 = 990 if HN042_2==1500;

gen mmiss=.;
replace mmiss=0 if HN040_2>-100 & HN040_2<991;
replace mmiss=1 if HN040_2>990 & HN040_2<19990;

replace exactvalue=HN040_2;
replace lowervalue=HN041_2;
replace uppervalue=HN042_2;

imputethis;
gen ins6_3 = exactvalue*12;
replace ins6_3=0 if ins6_3==.;

/*
*bomb;
gen ins6_3 = HN040_2;
replace ins6_3 = . if ins6_3 > 997;
egen mymin=min(HN042_2/5) if (HN042_2~=0 & HN042_2~=.);
replace HN041_2=mymin if HN041_2==0; drop mymin;
replace ins6_3=sqrt(HN041_2*HN042_2) if (HN041_2~=. & HN042_2~=.);
sum ins6_3 if HN040_2~=0 & HN040_2~=.;
sum ins6_3 if HN041_2~=. & HN042_2~=.;

replace ins6_3 = (HN041_2 + HN042_2)/2 if ins6_3 == .;
replace ins6_3 = 0 if ins6_3 == .;
replace ins6_3 = ins6_3*12;

*replace ins6_3 = 0 if HN033_2 == 1;
*replace ins6_3 = 0 if HN035_2 == 1;
replace ins6_3 = 0 if HN039_2 == 3;
*/

********************** impute ins6_4 using brackets ***********;
replace HN042_3 = 990 if HN042_3==1500;

gen mmiss=.;
replace mmiss=0 if HN040_3>-100 & HN040_3<991;
replace mmiss=1 if HN040_3>990 & HN040_3<19990;

replace exactvalue=HN040_3;
replace lowervalue=HN041_3;
replace uppervalue=HN042_3;

imputethis;
gen ins6_4 = exactvalue*12;
replace ins6_4=0 if ins6_4==.;

/*
gen ins6_4 = HN040_3;
replace ins6_4 = . if ins6_4 > 997;
egen mymin=min(HN042_3/5) if (HN042_3~=0 & HN042_3~=.);
replace HN041_3=mymin if HN041_3==0; drop mymin;
replace ins6_4=sqrt(HN041_3*HN042_3) if (HN041_3~=. & HN042_3~=.);
sum ins6_4 if HN040_3~=0 & HN040_3~=.;
sum ins6_4 if HN041_3~=. & HN042_3~=.;
replace ins6_4 = 0 if ins6_4 == .;
replace ins6_4 = ins6_4*12;
replace ins6_4 = 0 if HN039_3 == 3;
*/

********************** impute ins6_5 using brackets ***********;

replace HN079 = HN079/12 if HN083 == 1;
replace HN079 = HN079/3 if HN083 == 2;
replace HN079 = . if HN083>4 & HN083~=.;

replace HN081=100001 if HN081==4000;

gen mmiss=.;
replace mmiss=0 if HN079>-100 & HN079<999990;
replace mmiss=1 if HN079>999990 & HN079<199999999;

replace exactvalue=HN079;
replace lowervalue=HN080;
replace uppervalue=HN081;

imputethis;
gen ins6_5 = exactvalue * 12;
replace ins6_5=0 if ins6_5==.; //what to if HN079<9990 & HN083>4? Here ins6_5=0 in that case;

/*
gen ins6_5 = HN079;
replace ins6_5 = . if HN079 > 999997;
replace ins6_5 = ins6_5*4 if HN083 == 2;
replace ins6_5 = ins6_5*12 if HN083 == 4;
replace ins6_5 = . if HN083 > 4;
egen mymin=min(HN081/5) if (HN081~=0 & HN081~=.);
replace HN080=mymin if HN080==0; drop mymin;
replace ins6_5 = (sqrt(HN080*HN081))*12 if (HN080~=. & HN081~=.) & ins6_5 == .;
sum ins6_5 if HN079~=0 & HN079~=.;
sum ins6_5 if HN080~=. & HN081~=.;
replace ins6_5 = 0 if ins6_5 == .;
*/

gen iprem6= ins6_1 + ins6_2 + ins6_3 + ins6_4 + ins6_5;

keep tc6 HHID PN ins* iprem*;
gen t2 = real(HHID);
drop HHID;
rename t2 HHID;
gen t2 = real(PN);
drop PN;
rename t2 PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

merge HHID PN using `saved'medcost;
drop _merge;

replace iprem6a=. if iprem6==.; * missings are counted as 0s in the imputation file;

gen medcost6 = oop6 + iprem6 + drugc6;

sort HHID PN;
sleep 1000; save `saved'medcost, replace; 

*bomb;
clear;






*infile using "C:\Research\hrs\wave6\408kupdate\same_name\H02N_R.dct";
*sum HN180;
*gen ins6_1 = 0;
*replace ins6_1 = HN014*12 if HN018 == 1;
*replace ins6_1 = HN014*4 if HN018 == 2;
*replace ins6_1 = HN014*2 if HN018 == 3;
*replace ins6_1 = HN014 if HN018 == 4;

*gen ins6_2 = HN040_1*12;
*replace ins6_2 = 0 if ins6_2 == .;
*replace ins6_2 = 0 if ins6_2 > 997;
*gen ins6_3 = HN040_2*12;
*replace ins6_3 = 0 if ins6_3 == .;
*replace ins6_3 = 0 if ins6_3 > 997;
*gen ins6_4 = HN040_3*12;
*replace ins6_4 = 0 if ins6_4 == .;
*replace ins6_4 = 0 if ins6_4 > 997;
*gen ins6_5 = HN079*12;
*replace ins6_5 = 0 if ins6_5 == .;
*replace ins6_5 = 0 if ins6_5 > 999997;
                               
*gen iprem6 = ins6_1 + ins6_2 + ins6_3 + ins6_4 + ins6_5;
*sum ins6*;
*sum iprem6;
*keep iprem6 HHID PN;
*gen tmp = real(HHID);
*drop HHID;
*rename tmp HHID;
*gen tmp = real(PN);
*drop PN;
*rename tmp PN;
*sort HHID PN;
*merge HHID PN using `saved'medcost;
*drop _merge;
*sort HHID PN;
*save `saved'medcost, replace;





*********************Wave VII***********************;

use `wave7d'h04i_nr;
save `wave7d'h04i_nr.dta, replace;

use `wave7d'h04i_nr;
sort HHID PN;
gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;
sort HHID PN;

merge HHID PN using `saved'medcost;
drop _merge;

***OOP Annual Expenses******;
gen hospc7=JN106X/2; *imputed oop hospital costs;
gen nursc7=JN119X/2; *imputed oop nursing home costs;
gen outsgc7=JN139X/2; *imputed oop outpatient surgery costs;
gen docc7=JN156X/2; *imputed oop doctor visits costs;
gen dentc7=JN168X/2; *imputed oop dental costs;
gen drugc7=(JN180X*12); *imputed oop rx drug costs;
gen hhsc7=JN194X/2; *imputed oop home health service costs;
gen othels7=JN239X/2; *imputed oop amt. other health services;
gen oop7=hospc7+nursc7+outsgc7+docc7+dentc7+hhsc7+othels7;
*gen oop7b = hospc7+docc7+othels7;
*gen oop7c = hospc7+docc7+othels7+outsgc7;
*gen oop7 = hospc7+docc7+othels7+outsgc7+nursc7+hhsc7;

sort HHID PN;
sleep 1000; save `saved'medcost, replace; 
clear;


use `wave7d'H04N_R;
* Phil: Total medical costs are _totally_ lacking;
*gen tc6a = (HN222 + HN223)/2;
*gen tc6b = sqrt(HN222*HN223);
*gen tc6=tc6b;
*sum tc6*;

********************** impute ins7_1 using brackets ***********;

replace JN014 = JN014/3 if JN018 == 2;
replace JN014 = JN014/6 if JN018 == 3;
replace JN014 = JN014/12 if JN018 == 4;
replace JN014 = . if JN018>4 & JN018~=.;

replace JN016=1001 if JN016==99999996;

gen mmiss=.;
replace mmiss=0 if JN014>-100 & JN014<9991;
replace mmiss=1 if JN014>9990 & JN014<199999999;

gen exactvalue=JN014;
gen lowervalue=JN015;
gen uppervalue=JN016;

imputethis;
gen ins7_1 = exactvalue * 12;
replace ins7_1=0 if ins7_1==.; //what to if JN014<9990 & JN018>4? Here ins7_1=0 in that case;

/*
gen ins7_1 = JN014;
replace ins7_1 = . if JN014 > 9997;
gen mymin=7 ;
replace JN015=mymin if JN015==0; drop mymin;
gen mymax=240;
replace JN016=mymax if JN016>mymax; drop mymax;
replace ins7_1=sqrt(JN015*JN016) if (JN015~=. & JN016~=.) & ins7_1==.;
sum JN014 JN015 JN016 ins7_1;

replace ins7_1 = ins7_1*12 if JN018 == 1;
replace ins7_1 = ins7_1*4 if JN018 == 2;
replace ins7_1 = ins7_1*2 if JN018 == 3;
replace ins7_1 = . if JN018 > 4;
replace ins7_1 = 0 if ins7_1 == .;
*/


********************** impute ins7_2 using brackets ***********;

replace JN042_1 = 2500 if JN042_1==99999996;

gen mmiss=.;
replace mmiss=0 if JN040_1>-100 & JN040_1<9991;
replace mmiss=1 if JN040_1>9990 & JN040_1<199990;

replace exactvalue=JN040_1;
replace lowervalue=JN041_1;
replace uppervalue=JN042_1;

imputethis;
gen ins7_2 = exactvalue*12;
replace ins7_2=0 if ins7_2==.;

/*
gen ins7_2 = JN040_1;
replace ins7_2 = . if ins7_2 > 9997;
gen mymin=12; gen mymax=300; 
replace JN041_1=mymin if JN041_1==0; drop mymin;
replace JN042_1=mymax if JN042_1>mymax & JN042_1~=.; drop mymax;
replace ins7_2=sqrt(JN041_1*JN042_1) if (JN041_1~=. & JN042_1~=.) & ins7_2==.;
sum ins7_2 if JN040_1~=0 & JN040_1~=.;
sum ins7_2 if JN041_1~=. & JN042_1~=.;
replace ins7_2 = 0 if ins7_2 == .;
replace ins7_2 = ins7_2*12;
replace ins7_2 = 0 if JN039_1 == 3;
*/

********************** impute ins7_3 using brackets ***********;
replace JN042_2 = 990 if JN042_2==99999996;

gen mmiss=.;
replace mmiss=0 if JN040_2>-100 & JN040_2<9991;
replace mmiss=1 if JN040_2>9990 & JN040_2<199990;

replace exactvalue=JN040_2;
replace lowervalue=JN041_2;
replace uppervalue=JN042_2;

imputethis;
gen ins7_3 = exactvalue*12;
replace ins7_3=0 if ins7_3==.;

/*
gen ins7_3 = JN040_2;
replace ins7_3 = . if ins7_3 > 9997;
gen mymin=12; gen mymax=300;
replace JN041_2=mymin if JN041_2==0; drop mymin;
replace JN042_2=mymax if JN042_2>mymax & JN042_2; drop mymax;
replace ins7_3=sqrt(JN041_2*JN042_2) if (JN041_2~=. & JN042_2~=.) & ins7_3==.;
sum ins7_3 if JN040_2~=0 & JN040_2~=.;
sum ins7_3 if JN041_2~=. & JN042_2~=.;
replace ins7_3 = 0 if ins7_3 == .;
replace ins7_3 = ins7_3*12;
replace ins7_3 = 0 if JN039_2 == 3;
*/

********************** impute ins7_4 using brackets ***********;
replace JN042_3 = 990 if JN042_3==99999996;

gen mmiss=.;
replace mmiss=0 if JN040_3>-100 & JN040_3<9991;
replace mmiss=1 if JN040_3>9990 & JN040_3<199990;

replace exactvalue=JN040_3;
replace lowervalue=JN041_3;
replace uppervalue=JN042_3;

imputethis;
gen ins7_4 = exactvalue*12;
replace ins7_4=0 if ins7_4==.;

/*
gen ins7_4 = JN040_3;
replace ins7_4 = . if ins7_4 > 9997; 
gen mymin=12; gen mymax=300;
replace JN041_3=mymin if JN041_3==0; drop mymin;
replace JN042_3=mymax if JN042_3>mymax & JN042_3~=0; drop mymax;
replace ins7_4=sqrt(JN041_3*JN042_3) if (JN041_3~=. & JN042_3~=.) & ins7_4==.;
sum ins7_4 if JN040_3~=0 & JN040_3~=.;
sum ins7_4 if JN041_3~=. & JN042_3~=.;
replace ins7_4 = 0 if ins7_4 == .;
replace ins7_4 = ins7_4*12;
replace ins7_4 = 0 if JN039_3 == 3;
*/

********************** impute ins7_5 using brackets ***********;

replace JN079 = JN079/12 if JN083 == 1;
replace JN079 = JN079/3 if JN083 == 2;
replace JN079 = . if JN083>4 & JN083~=.;

replace JN081=50001 if JN081==99999996;

gen mmiss=.;
replace mmiss=0 if JN079>-100 & JN079<99990;
replace mmiss=1 if JN079>99990 & JN079<199999999;

replace exactvalue=JN079;
replace lowervalue=JN080;
replace uppervalue=JN081;

imputethis;
gen ins7_5 = exactvalue * 12;
replace ins7_5=0 if ins7_5==.; //what to if JN079<99990 & JN083>4? Here ins7_5=0 in that case;

/*
gen ins7_5 = JN079;
replace ins7_5 = . if JN079 > 99997;
replace ins7_5 = ins7_5*4 if JN083 == 2;
replace ins7_5 = ins7_5*12 if JN083 == 4;
replace ins7_5 = . if JN083 > 4;


gen mymin=12; gen mymax=800;
replace JN080=mymin if JN080==0; drop mymin;
replace JN081=mymax if JN081>mymax & JN081~=.; drop mymax;
replace ins7_5 = (sqrt(JN080*JN081))*12 if (JN080~=. & JN081~=.) & ins7_5 ==.;
sum ins7_5 if JN079~=0 & JN079~=.;
sum ins7_5 if JN080~=. & JN081~=.;
replace ins7_5 = 0 if ins7_5 == .;
*/


gen iprem7= ins7_1 + ins7_2 + ins7_3 + ins7_4 + ins7_5;

keep HHID PN ins* iprem* JN040_1;
gen t2 = real(HHID);
drop HHID;
rename t2 HHID;
gen t2 = real(PN);
drop PN;
rename t2 PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

merge HHID PN using `saved'medcost;
drop _merge;

replace JN040_1 = . if JN040_1>9997;
replace JN040_1X=JN040_1;

gen ins7_1a=JN014X; *imputed MEDICARE/MEDICAID HMO-AMT PAY; *Phil: I can't
find the freq on this;
gen ins7_2a=JN040_1X; *imputed PRIV PLAN HI PAY PER/MONTH- AMT- 1;
gen ins7_3a=JN040_2X; *imputed PRIV PLAN HI PAY PER/MONTH- AMT- 2;
gen ins7_4a=JN040_3X; *imputed PRIV PLAN HI PAY PER/MONTH- AMT- 3;
gen ins7_5a=JN079X; *imputed AMT PAY FOR LTC;
replace ins7_1a = 0 if ins7_1a == .;
replace ins7_2a = 0 if ins7_2a == .;
replace ins7_3a = 0 if ins7_3a == .;
replace ins7_4a = 0 if ins7_4a == .;
replace ins7_5a = 0 if ins7_5a == .;
replace ins7_1a = ins7_1a*12;
replace ins7_2a = ins7_2a*12;
replace ins7_3a = ins7_3a*12;
replace ins7_4a = ins7_4a*12;
replace ins7_5a = ins7_5a;

gen iprem7a = ins7_1a + ins7_2a + ins7_3a + ins7_4a + ins7_5a;

*sum hospc7 nursc7 outsgc7 docc7 dentc7 drugc7 hhsc7 othels7 medcarex7
ins7_1 ins7_2 ins7_3 ins7_4 ltc7;
*bomb;
keep HHID PN medcost*  hospc* nursc* outsgc* docc* dentc* hhsc* othels* oop* drugc* tc* iprem* ins*;
*keep HHID PN oop* drugc* iprem* ins*;
*drop iprem7;
summ;
gen medcost7a = oop7 + iprem7a + drugc7;
sort HHID PN;

replace iprem7a=. if iprem7==.; * missings are counted as 0s in the imputation file;

gen medcost7 = oop7 + iprem7 + drugc7;

sort HHID PN;
sleep 1000; save `saved'medcost, replace; 

clear;





;




*********************Wave VIII***********************;

*infile using `wave8d'h06i_nr.dct;
*save `wave8d'h04i_nr.dta, replace;

*use `wave8d'h06i_nr;
*sort HHID PN;
*gen temp=real(HHID);
*drop HHID;
*rename temp HHID;
*gen temp=real(PN);
*drop PN;
*rename temp PN;
*sort HHID PN;

*merge HHID PN using `saved'medcost;
*drop _merge;

***OOP Annual Expenses******;
*gen hospc8=KN106X/2; *imputed oop hospital costs;
*gen nursc8=KN119X/2; *imputed oop nursing home costs;
*gen outsgc8=KN139X/2; *imputed oop outpatient surgery costs;
*gen docc8=KN156X/2; *imputed oop doctor visits costs;
*gen dentc8=KN168X/2; *imputed oop dental costs;
*gen drugc8=(KN180X*12); *imputed oop rx drug costs;
*gen hhsc8=KN194X/2; *imputed oop home health service costs;
*gen othels8=KN239X/2; *imputed oop amt. other health services;
*gen oop8=hospc8+nursc8+outsgc8+docc8+dentc8+hhsc8+othels8;
*gen oop8b = hospc8+docc8+othels8;
*gen oop8c = hospc8+docc8+othels8+outsgc8;
*gen oop8 = hospc8+docc8+othels8+outsgc8+nursc8+hhsc8;




*sort HHID PN;
* save `saved'medcost, replace; 
*clear;


use `wave8d'H06N_R;
* Phil: Total medical costs are _totally_ lacking;
*gen tc6a = (HN222 + HN223)/2;
*gen tc6b = sqrt(HN222*HN223);
*gen tc6=tc6b;
*sum tc6*;

********************** impute ins8_1 using brackets ***********;

replace KN014 = KN014/3 if KN018 == 2;
replace KN014 = KN014/6 if KN018 == 3;
replace KN014 = KN014/12 if KN018 == 4;
replace KN014 = . if KN018>4 & KN018~=.;

replace KN016=950 if KN016==99999996;

gen mmiss=.;
replace mmiss=0 if KN014>-100 & KN014<991;
replace mmiss=1 if KN014>990 & KN014<199999999;

gen exactvalue=KN014;
gen lowervalue=KN015;
gen uppervalue=KN016;

imputethis;
gen ins8_1 = exactvalue * 12;
replace ins8_1=0 if ins8_1==.; //what to if KN014<990 & KN018>4? Here ins8_1=0 in that case;

/*
gen ins8_1 = KN014;
replace ins8_1 = . if KN014 > 938;
gen mymin=8 ;
replace KN015=mymin if KN015==0; drop mymin;
gen mymax=240;
replace KN016=mymax if KN016>mymax; drop mymax;
replace ins8_1=sqrt(KN015*KN016) if (KN015~=. & KN016~=.) & ins8_1==.;
sum KN014 KN015 KN016 ins8_1;

replace ins8_1 = ins8_1*12 if KN018 == 1;
replace ins8_1 = ins8_1*4 if KN018 == 2;
replace ins8_1 = ins8_1*2 if KN018 == 3;
replace ins8_1 = . if KN018 > 4;
replace ins8_1 = 0 if ins8_1 == .;
*/

********************** impute ins8_2 using brackets ***********;

replace KN042_1 = 996 if KN042_1==99999996;

gen mmiss=.;
replace mmiss=0 if KN040_1>-100 & KN040_1<997;
replace mmiss=1 if KN040_1>997 & KN040_1<199990;

replace exactvalue=KN040_1;
replace lowervalue=KN041_1;
replace uppervalue=KN042_1;

imputethis;
gen ins8_2 = exactvalue*12;
replace ins8_2=0 if ins8_2==.;

/*
gen ins8_2 = KN040_1;
replace ins8_2 = . if ins8_2 > 997;
gen mymin=12; gen mymax=300; 
replace KN041_1=mymin if KN041_1==0; drop mymin;
replace KN042_1=mymax if KN042_1>mymax & KN042_1~=.; drop mymax;
replace ins8_2=sqrt(KN041_1*KN042_1) if (KN041_1~=. & KN042_1~=.) & ins8_2==.;
sum ins8_2 if KN040_1~=0 & KN040_1~=.;
sum ins8_2 if KN041_1~=. & KN042_1~=.;
replace ins8_2 = 0 if ins8_2 == .;
replace ins8_2 = ins8_2*12;
replace ins8_2 = 0 if KN039_1 == 3;
*/

********************** impute ins8_3 using brackets ***********;
replace KN042_2 = 990 if KN042_2==99999996;

gen mmiss=.;
replace mmiss=0 if KN040_2>-100 & KN040_2<997;
replace mmiss=1 if KN040_2>997 & KN040_2<199990;

replace exactvalue=KN040_2;
replace lowervalue=KN041_2;
replace uppervalue=KN042_2;

imputethis;
gen ins8_3 = exactvalue*12;
replace ins8_3=0 if ins8_3==.;

/*
gen ins8_3 = KN040_2;
replace ins8_3 = . if ins8_3 > 997;
gen mymin=12; gen mymax=300;
replace KN041_2=mymin if KN041_2==0; drop mymin;
replace KN042_2=mymax if KN042_2>mymax & KN042_2; drop mymax;
replace ins8_3=sqrt(KN041_2*KN042_2) if (KN041_2~=. & KN042_2~=.) & ins8_3==.;
sum ins8_3 if KN040_2~=0 & KN040_2~=.;
sum ins8_3 if KN041_2~=. & KN042_2~=.;
replace ins8_3 = 0 if ins8_3 == .;
replace ins8_3 = ins8_3*12;
replace ins8_3 = 0 if KN039_2 == 3;
*/


********************** impute ins8_4 using brackets ***********;
replace KN042_3 = 990 if KN042_3==99999996;

gen mmiss=.;
replace mmiss=0 if KN040_3>-100 & KN040_3<997;
replace mmiss=1 if KN040_3>997 & KN040_3<199990;

replace exactvalue=KN040_3;
replace lowervalue=KN041_3;
replace uppervalue=KN042_3;

imputethis;
gen ins8_4 = exactvalue*12;
replace ins8_4=0 if ins8_4==.;

/*
gen ins8_4 = KN040_3;
replace ins8_4 = . if ins8_4 > 997; 
gen mymin=12; gen mymax=300;
replace KN041_3=mymin if KN041_3==0; drop mymin;
replace KN042_3=mymax if KN042_3>mymax & KN042_3~=0; drop mymax;
replace ins8_4=sqrt(KN041_3*KN042_3) if (KN041_3~=. & KN042_3~=.) & ins8_4==.;
sum ins8_4 if KN040_3~=0 & KN040_3~=.;
sum ins8_4 if KN041_3~=. & KN042_3~=.;
replace ins8_4 = 0 if ins8_4 == .;
replace ins8_4 = ins8_4*12;
replace ins8_4 = 0 if KN039_3 == 3;
*/

********************** impute ins8_5 using brackets ***********;

replace KN079 = KN079/3 if KN083 == 2;
replace KN079 = KN079/12 if KN083 == 4;
replace KN079 = KN079*4 if KN083 == 3;
replace KN079 = . if KN083>4 & KN083~=.;

replace KN081=200000 if KN081==99999996;

gen mmiss=.;
replace mmiss=0 if KN079>-100 & KN079<999990;
replace mmiss=1 if KN079>999990 & KN079<199999999;

replace exactvalue=KN079;
replace lowervalue=KN080;
replace uppervalue=KN081;

imputethis;
gen ins8_5 = exactvalue * 12;
replace ins8_5=0 if ins8_5==.; //what if KN079<999990 & KN083>4? Here ins8_5=0 in that case;

/*
gen ins8_5 = KN079;
replace ins8_5 = . if KN079 > 999997;
replace ins8_5 = ins8_5*4 if KN083 == 2;
replace ins8_5 = ins8_5*12 if KN083 == 1;
replace ins8_5 = . if KN083 > 4;


gen mymin=12; gen mymax=800;
replace KN080=mymin if KN080==0; drop mymin;
replace KN081=mymax if KN081>mymax & KN081~=.; drop mymax;
replace ins8_5 = (sqrt(KN080*KN081))*12 if (KN080~=. & KN081~=.) & ins8_5 ==.;
sum ins8_5 if KN079~=0 & KN079~=.;
sum ins8_5 if KN080~=. & KN081~=.;
replace ins8_5 = 0 if ins8_5 == .;
*/


gen iprem8= ins8_1 + ins8_2 + ins8_3 + ins8_4 + ins8_5;

keep HHID PN ins* iprem* KN040_1*;
gen t2 = real(HHID);
drop HHID;
rename t2 HHID;
gen t2 = real(PN);
drop PN;
rename t2 PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

merge HHID PN using `saved'medcost;
drop _merge;

replace KN040_1 = . if KN040_1>997;

*I have deleted the imputed insurance variables.

*sum hospc8 nursc8 outsgc8 docc8 dentc8 drugc8 hhsc8 othels8 medcarex8
ins8_1 ins8_2 ins8_3 ins8_4 ltc8;
*bomb;

*Jon: Here are generate all of the variables that would have been generated if the imputed HRS data was available.;
gen hospc8=.;
gen nursc8=.;
gen outsgc8=.;
gen docc8=.;
gen dentc8=.;
gen drugc8=.;
gen hhsc8=.;
gen othels8=.;
gen oop8=.;
gen oop8b =. ;
gen oop8c = .;


keep HHID PN medcost*  hospc* nursc* outsgc* docc* dentc* hhsc* othels* oop* drugc* tc* iprem* ins*;
*keep HHID PN oop* drugc* iprem* ins*;
*drop iprem8;
summ;
*gen medcost8a = oop8 + iprem8a + drugc8;
sort HHID PN;

*replace iprem8a=. if iprem8==.; * missings are counted as 0s in the imputation file;

gen medcost8 = oop8 + iprem8 + drugc8;

sort HHID PN;
sleep 1000; save `saved'medcost, replace; 

clear;





;



*********************Wave IX***********************;

*infile using `wave9d'h08i_nr.dct;
*save `wave9d'h08i_nr.dta, replace;

*use `wave9d'h08i_nr;
*sort HHID PN;
*gen temp=real(HHID);
*drop HHID;
*rename temp HHID;
*gen temp=real(PN);
*drop PN;
*rename temp PN;
*sort HHID PN;

*merge HHID PN using `saved'medcost;
*drop _merge;

***OOP Annual Expenses******;
*gen hospc9=LN106X/2; *imputed oop hospital costs;
*gen nursc9=LN119X/2; *imputed oop nursing home costs;
*gen outsgc9=LN139X/2; *imputed oop outpatient surgery costs;
*gen docc9=LN156X/2; *imputed oop doctor visits costs;
*gen dentc9=LN168X/2; *imputed oop dental costs;
*gen drugc9=(LN180X*12); *imputed oop rx drug costs;
*gen hhsc9=LN194X/2; *imputed oop home health service costs;
*gen othels9=LN239X/2; *imputed oop amt. other health services;
*gen oop9=hospc9+nursc9+outsgc9+docc9+dentc9+hhsc9+othels9;
*gen oop9b = hospc9+docc9+othels9;
*gen oop9c = hospc9+docc9+othels9+outsgc9;
*gen oop9 = hospc9+docc9+othels9+outsgc9+nursc9+hhsc9;




*sort HHID PN;
* save `saved'medcost, replace; 
*clear;


use `wave9d'H08N_R;
* Phil: Total medical costs are _totally_ lacking;
*gen tc6a = (HN222 + HN223)/2;
*gen tc6b = sqrt(HN222*HN223);
*gen tc6=tc6b;
*sum tc6*;

********************** impute ins9_1 using brackets ***********;

replace LN014 = LN014/3 if LN018 == 2;
replace LN014 = LN014/6 if LN018 == 3;
replace LN014 = LN014/12 if LN018 == 4;
replace LN014 = . if LN018>4 & LN018~=.;

replace LN016=997 if LN016==9996;

gen mmiss=.;
replace mmiss=0 if LN014>-100 & LN014<997;
replace mmiss=1 if LN014>997 & LN014<199999999;

gen exactvalue=LN014;
gen lowervalue=LN015;
gen uppervalue=LN016;

imputethis;
gen ins9_1 = exactvalue * 12;
replace ins9_1=0 if ins9_1==.; //what to if KN014<990 & KN018>4? Here ins8_1=0 in that case;

/*
gen ins9_1 = LN014;
replace ins9_1 = . if LN014 > 938;
gen mymin=8 ;
replace LN015=mymin if LN015==0; drop mymin;
gen mymax=240;
replace LN016=mymax if LN016>mymax; drop mymax;
replace ins9_1=sqrt(LN015*LN016) if (LN015~=. & LN016~=.) & ins9_1==.;
sum LN014 LN015 LN016 ins9_1;

replace ins9_1 = ins9_1*12 if LN018 == 1;
replace ins9_1 = ins9_1*4 if LN018 == 2;
replace ins9_1 = ins9_1*2 if LN018 == 3;
replace ins9_1 = . if LN018 > 4;
replace ins9_1 = 0 if ins9_1 == .;
*/

********************** impute ins9_2 using brackets ***********;

replace LN042_1 = 6400 if LN042_1==9996;

gen mmiss=.;
replace mmiss=0 if LN040_1>-100 & LN040_1<99991;
replace mmiss=1 if LN040_1>99990 & LN040_1<199990;

replace exactvalue=LN040_1;
replace lowervalue=LN041_1;
replace uppervalue=LN042_1;

imputethis;
gen ins9_2 = exactvalue*12;
replace ins9_2=0 if ins9_2==.;

/*
gen ins9_2 = LN040_1;
replace ins9_2 = . if ins9_2 > 997;
gen mymin=12; gen mymax=300; 
replace LN041_1=mymin if LN041_1==0; drop mymin;
replace LN042_1=mymax if LN042_1>mymax & LN042_1~=.; drop mymax;
replace ins9_2=sqrt(LN041_1*LN042_1) if (LN041_1~=. & LN042_1~=.) & ins9_2==.;
sum ins9_2 if LN040_1~=0 & LN040_1~=.;
sum ins9_2 if LN041_1~=. & LN042_1~=.;
replace ins9_2 = 0 if ins9_2 == .;
replace ins9_2 = ins9_2*12;
replace ins9_2 = 0 if LN039_1 == 3;
*/

********************** impute ins9_3 using brackets ***********;
replace LN042_2 = 4000 if LN042_2==9996;

gen mmiss=.;
replace mmiss=0 if LN040_2>-100 & LN040_2<99991;
replace mmiss=1 if LN040_2>99990 & LN040_2<199990;

replace exactvalue=LN040_2;
replace lowervalue=LN041_2;
replace uppervalue=LN042_2;

imputethis;
gen ins9_3 = exactvalue*12;
replace ins9_3=0 if ins9_3==.;

/*
gen ins9_3 = LN040_2;
replace ins9_3 = . if ins9_3 > 997;
gen mymin=12; gen mymax=300;
replace LN041_2=mymin if LN041_2==0; drop mymin;
replace LN042_2=mymax if LN042_2>mymax & LN042_2; drop mymax;
replace ins9_3=sqrt(LN041_2*LN042_2) if (LN041_2~=. & LN042_2~=.) & ins9_3==.;
sum ins9_3 if LN040_2~=0 & LN040_2~=.;
sum ins9_3 if LN041_2~=. & LN042_2~=.;
replace ins9_3 = 0 if ins9_3 == .;
replace ins9_3 = ins9_3*12;
replace ins9_3 = 0 if LN039_2 == 3;
*/

********************** impute ins9_4 using brackets ***********;
replace LN042_3 = 990 if LN042_3==996;

gen mmiss=.;
replace mmiss=0 if LN040_3>-100 & LN040_3<9991;
replace mmiss=1 if LN040_3>9990 & LN040_3<199990;

replace exactvalue=LN040_3;
replace lowervalue=LN041_3;
replace uppervalue=LN042_3;

imputethis;
gen ins9_4 = exactvalue*12;
replace ins9_4=0 if ins9_4==.;

/*
gen ins9_4 = LN040_3;
replace ins9_4 = . if ins9_4 > 997; 
gen mymin=12; gen mymax=300;
replace LN041_3=mymin if LN041_3==0; drop mymin;
replace LN042_3=mymax if LN042_3>mymax & LN042_3~=0; drop mymax;
replace ins9_4=sqrt(LN041_3*LN042_3) if (LN041_3~=. & LN042_3~=.) & ins9_4==.;
sum ins9_4 if LN040_3~=0 & LN040_3~=.;
sum ins9_4 if LN041_3~=. & LN042_3~=.;
replace ins9_4 = 0 if ins9_4 == .;
replace ins9_4 = ins9_4*12;
replace ins9_4 = 0 if LN039_3 == 3;
*/

********************** impute ins9_5 using brackets ***********;

replace LN079 = LN079/3 if LN083 == 2;
replace LN079 = LN079/12 if LN083 == 4;
replace LN079 = . if LN083>4 & LN083~=.;

replace LN081=100001 if LN081==9996;

gen mmiss=.;
replace mmiss=0 if LN079>-100 & LN079<999990;
replace mmiss=1 if LN079>999990 & LN079<199999999;

replace exactvalue=LN079;
replace lowervalue=LN080;
replace uppervalue=LN081;

imputethis;
gen ins9_5 = exactvalue * 12;
replace ins9_5=0 if ins9_5==.; //what if LN079<999990 & LN083>4? Here ins9_5=0 in that case;

/*
gen ins9_5 = LN079;
replace ins9_5 = . if LN079 > 999997;
replace ins9_5 = ins9_5*4 if LN083 == 2;
replace ins9_5 = ins9_5*12 if LN083 == 1;
replace ins9_5 = . if LN083 > 4;


gen mymin=12; gen mymax=800;
replace LN080=mymin if LN080==0; drop mymin;
replace LN081=mymax if LN081>mymax & LN081~=.; drop mymax;
replace ins9_5 = (sqrt(LN080*LN081))*12 if (LN080~=. & LN081~=.) & ins9_5 ==.;
sum ins9_5 if LN079~=0 & LN079~=.;
sum ins9_5 if LN080~=. & LN081~=.;
replace ins9_5 = 0 if ins9_5 == .;
*/


gen iprem9= ins9_1 + ins9_2 + ins9_3 + ins9_4 + ins9_5;

keep HHID PN ins* iprem* LN040_1*;
gen t2 = real(HHID);
drop HHID;
rename t2 HHID;
gen t2 = real(PN);
drop PN;
rename t2 PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

merge HHID PN using `saved'medcost;
drop _merge;

replace LN040_1 = . if LN040_1>99997;

*I have deleted the imputed insurance variables.

*sum hospc9 nursc9 outsgc9 docc9 dentc9 drugc9 hhsc9 othels9 medcarex9
ins9_1 ins9_2 ins9_3 ins9_4 ltc9;
*bomb;

*Jon: Here are generate all of the variables that would have been generated if the imputed HRS data was available.;
gen hospc9=.;
gen nursc9=.;
gen outsgc9=.;
gen docc9=.;
gen dentc9=.;
gen drugc9=.;
gen hhsc9=.;
gen othels9=.;
gen oop9=.;
gen oop9b =. ;
gen oop9c = .;


keep HHID PN medcost*  hospc* nursc* outsgc* docc* dentc* hhsc* othels* oop* drugc* tc* iprem* ins*;
*keep HHID PN oop* drugc* iprem* ins*;
*drop iprem9;
summ;
*gen medcost9a = oop9 + iprem9a + drugc9;
sort HHID PN;

*replace iprem9a=. if iprem9==.; * missings are counted as 0s in the imputation file;

gen medcost9 = oop9 + iprem9 + drugc9;

sort HHID PN;
sleep 1000; save `saved'medcost, replace; 

clear;





;


*********************Wave X***********************;

*infile using `wave10d'h10i_nr.dct;
*save `wave10d'h10i_nr.dta, replace;

*use `wave9d'h08i_nr;
*sort HHID PN;
*gen temp=real(HHID);
*drop HHID;
*rename temp HHID;
*gen temp=real(PN);
*drop PN;
*rename temp PN;
*sort HHID PN;

*merge HHID PN using `saved'medcost;
*drop _merge;

***OOP Annual Expenses******;
*gen hospc9=LN106X/2; *imputed oop hospital costs;
*gen nursc9=LN119X/2; *imputed oop nursing home costs;
*gen outsgc9=LN139X/2; *imputed oop outpatient surgery costs;
*gen docc9=LN156X/2; *imputed oop doctor visits costs;
*gen dentc9=LN168X/2; *imputed oop dental costs;
*gen drugc9=(LN180X*12); *imputed oop rx drug costs;
*gen hhsc9=LN194X/2; *imputed oop home health service costs;
*gen othels9=LN239X/2; *imputed oop amt. other health services;
*gen oop9=hospc9+nursc9+outsgc9+docc9+dentc9+hhsc9+othels9;
*gen oop9b = hospc9+docc9+othels9;
*gen oop9c = hospc9+docc9+othels9+outsgc9;
*gen oop9 = hospc9+docc9+othels9+outsgc9+nursc9+hhsc9;




*sort HHID PN;
* save `saved'medcost, replace; 
*clear;


use `wave10d'H10N_R;
* Phil: Total medical costs are _totally_ lacking;
*gen tc6a = (HN222 + HN223)/2;
*gen tc6b = sqrt(HN222*HN223);
*gen tc6=tc6b;
*sum tc6*;

********************** impute ins10_1 using brackets ***********;

*set N014 to monthly values for imputation purposes, since N015 and N016 are monthly
replace MN014 = MN014/3 if MN018 == 2; 
replace MN014 = MN014/6 if MN018 == 3;
replace MN014 = MN014/12 if MN018 == 4;
replace MN014 = . if MN018>4 & MN018~=.;

replace MN016=1001 if MN016==99999996;
*replacement value must be smaller than N014 error code but larger than its max value;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if MN014>-100 & MN014<9990; //check N014 error codes for changes
replace mmiss=1 if MN014>9990 & MN014<199999999;

gen exactvalue=MN014;
gen lowervalue=MN015;
gen uppervalue=MN016;

imputethis;
gen ins10_1 = exactvalue * 12;
replace ins10_1=0 if ins10_1==.; //what if MN014<9990 & MN018>4? Here ins10_1=0 in that case;

********************** impute ins10_2 using brackets ***********;

replace MN042_1 = 10000 if MN042_1==99999996;
*replacement value must be smaller than N040_1 error code but larger than its max value;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if MN040_1>-100 & MN040_1<99990; //check N040_1 error codes for changes
replace mmiss=1 if MN040_1>99990 & MN040_1<19999990;

replace exactvalue=MN040_1;
replace lowervalue=MN041_1;
replace uppervalue=MN042_1;

imputethis;
gen ins10_2 = exactvalue*12;
replace ins10_2=0 if ins10_2==.;

********************** impute ins10_3 using brackets ***********;

replace MN042_2 = 5000 if MN042_2==99999996;
*replacement value must be smaller than N040_2 error code but larger than its max value;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if MN040_2>-100 & MN040_2<99990; //check N040_2 error codes for changes
replace mmiss=1 if MN040_2>99990 & MN040_2<19999990;

replace exactvalue=MN040_2;
replace lowervalue=MN041_2;
replace uppervalue=MN042_2;

imputethis;
gen ins10_3 = exactvalue*12;
replace ins10_3=0 if ins10_3==.;

********************** impute ins10_4 using brackets ***********;
replace MN042_3 = 1000 if MN042_3==99999996;
*replacement value must be smaller than N040_3 error code but larger than its max value;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if MN040_3>-100 & MN040_3<99990; //check N040_3 error codes for changes
replace mmiss=1 if MN040_3>99990 & MN040_3<19999990;

replace exactvalue=MN040_3;
replace lowervalue=MN041_3;
replace uppervalue=MN042_3;

imputethis;
gen ins10_4 = exactvalue*12;
replace ins10_4=0 if ins10_4==.;

********************** impute ins10_5 using brackets ***********;

*set N079 to monthly values for imputation purposes, since N015 and N016 are monthly;
replace MN079 = MN079/3 if MN083 == 2;
replace MN079 = MN079/12 if MN083 == 4;
replace MN079 = MN079*4 if MN083==3;
replace MN079 = . if MN083>4 & MN083~=.;

replace MN081=100001 if MN081==99999996;
*replacement value must be smaller than N040_3 error code but larger than its max value;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if MN079>-100 & MN079<999990; //check N079 error codes for changes
replace mmiss=1 if MN079>999990 & MN079<199999999;

replace exactvalue=MN079;
replace lowervalue=MN080;
replace uppervalue=MN081;

imputethis;
gen ins10_5 = exactvalue * 12;
replace ins10_5=0 if ins10_5==.; //what if MN079<999990 & MN083>4? Here ins10_5=0 in that case;




gen iprem10= ins10_1 + ins10_2 + ins10_3 + ins10_4 + ins10_5;

keep HHID PN ins* iprem* MN040_1*;
gen t2 = real(HHID);
drop HHID;
rename t2 HHID;
gen t2 = real(PN);
drop PN;
rename t2 PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

merge HHID PN using `saved'medcost;
drop _merge;

replace MN040_1 = . if MN040_1>99997;

*Jon: Here are generate all of the variables that would have been generated if the imputed HRS data was available.;
gen hospc10=.;
gen nursc10=.;
gen outsgc10=.;
gen docc10=.;
gen dentc10=.;
gen drugc10=.;
gen hhsc10=.;
gen othels10=.;
gen oop10=.;
gen oop10b =. ;
gen oop10c = .;


keep HHID PN medcost*  hospc* nursc* outsgc* docc* dentc* hhsc* othels* oop* drugc* tc* iprem* ins*;
*keep HHID PN oop* drugc* iprem* ins*;
*drop iprem9;
summ;
*gen medcost9a = oop9 + iprem9a + drugc9;
sort HHID PN;

*replace iprem9a=. if iprem9==.; * missings are counted as 0s in the imputation file;

gen medcost10 = oop10 + iprem10 + drugc10;

sort HHID PN;
sleep 1000; save `saved'medcost, replace; 

clear;









************* WAVE XI **************************;



use `wave11d'H12N_R;


********************** impute ins11_1 using brackets ***********;

*set N014 to monthly values for imputation purposes, since N015 and N016 are monthly
replace NN014 = NN014/3 if NN018 == 2; 
replace NN014 = NN014/6 if NN018 == 3;
replace NN014 = NN014/12 if NN018 == 4;
replace NN014 = . if NN018>4 & NN018~=.;

replace NN016=997 if NN016==99999996;
*replacement value must be smaller than N014 error code but larger than its max value;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if NN014>-100 & NN014<998; //check N014 error codes for changes
replace mmiss=1 if NN014>997 & NN014<199999999;

gen exactvalue=NN014;
gen lowervalue=NN015;
gen uppervalue=NN016;

imputethis;
gen ins11_1 = exactvalue * 12;
replace ins11_1=0 if ins11_1==.; //what if NN014<9990 & NN018>4? Here ins11_1=0 in that case;

********************** impute ins11_2 using brackets ***********;

replace NN042_1 = 10000 if NN042_1==99999996;
*replacement value must be smaller than N040_1 error code but larger than its max value;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if NN040_1>-100 & NN040_1<99990; //check N040_1 error codes for changes
replace mmiss=1 if NN040_1>99990 & NN040_1<19999990;

replace exactvalue=NN040_1;
replace lowervalue=NN041_1;
replace uppervalue=NN042_1;

imputethis;
gen ins11_2 = exactvalue*12;
replace ins11_2=0 if ins11_2==.;

********************** impute ins11_3 using brackets ***********;

replace NN042_2 = 5000 if NN042_2==99999996;
*replacement value must be smaller than N040_2 error code but larger than its max value;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if NN040_2>-100 & NN040_2<99990; //check N040_2 error codes for changes
replace mmiss=1 if NN040_2>99990 & NN040_2<19999990;

replace exactvalue=NN040_2;
replace lowervalue=NN041_2;
replace uppervalue=NN042_2;

imputethis;
gen ins11_3 = exactvalue*12;
replace ins11_3=0 if ins11_3==.;

********************** impute ins11_4 using brackets ***********;
replace NN042_3 = 1000 if NN042_3==99999996;
*replacement value must be smaller than N040_3 error code but larger than its max value;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if NN040_3>-100 & NN040_3<99990; //check N040_3 error codes for changes
replace mmiss=1 if NN040_3>99990 & NN040_3<19999990;

replace exactvalue=NN040_3;
replace lowervalue=NN041_3;
replace uppervalue=NN042_3;

imputethis;
gen ins11_4 = exactvalue*12;
replace ins11_4=0 if ins11_4==.;

********************** impute ins11_5 using brackets ***********;

*set N079 to monthly values for imputation purposes, since N015 and N016 are monthly;
replace NN079 = NN079/3 if NN083 == 2;
replace NN079 = NN079/12 if NN083 == 4;
replace NN079 = NN079*4 if NN083==3;
replace NN079 = . if NN083>4 & NN083~=.;

replace NN081=100001 if NN081==99999996;
*replacement value must be smaller than N040_3 error code but larger than its max value;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if NN079>-100 & NN079<999990; //check N079 error codes for changes
replace mmiss=1 if NN079>999990 & NN079<199999999;

replace exactvalue=NN079;
replace lowervalue=NN080;
replace uppervalue=NN081;

imputethis;
gen ins11_5 = exactvalue * 12;
replace ins11_5=0 if ins11_5==.; //what if NN079<999990 & NN083>4? Here ins11_5=0 in that case;




gen iprem11= ins11_1 + ins11_2 + ins11_3 + ins11_4 + ins11_5;

keep HHID PN ins* iprem* NN040_1*;
gen t2 = real(HHID);
drop HHID;
rename t2 HHID;
gen t2 = real(PN);
drop PN;
rename t2 PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

merge HHID PN using `saved'medcost;
drop _merge;

replace NN040_1 = . if NN040_1>99997;

*Jon: Here are generate all of the variables that would have been generated if the imputed HRS data was available.;
gen hospc11=.;
gen nursc11=.;
gen outsgc11=.;
gen docc11=.;
gen dentc11=.;
gen drugc11=.;
gen hhsc11=.;
gen othels11=.;
gen oop11=.;
gen oop11b =. ;
gen oop11c = .;


keep HHID PN medcost*  hospc* nursc* outsgc* docc* dentc* hhsc* othels* oop* drugc* tc* iprem* ins*;
*keep HHID PN oop* drugc* iprem* ins*;
*drop iprem9;
summ;
*gen medcost9a = oop9 + iprem9a + drugc9;
sort HHID PN;

*replace iprem9a=. if iprem9==.; * missings are counted as 0s in the imputation file;

gen medcost11 = oop11 + iprem11 + drugc11;

sort HHID PN;
sleep 1000; save `saved'medcost, replace; 

clear;

************* WAVE XII **************************;



use `wave12d'H14N_R;


********************** impute ins12_1 using brackets ***********;

*set N014 to monthly values for imputation purposes, since N015 and N016 are monthly
replace ON014 = ON014/3 if ON018 == 2; 
replace ON014 = ON014/6 if ON018 == 3;
replace ON014 = ON014/12 if ON018 == 4;
replace ON014 = . if ON018>4 & ON018~=.;

replace ON016=9997 if ON016==99999996;
*replacement value must be smaller than N014 error code but larger than its max value;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if ON014>-100 & ON014<9998; //check N014 error codes for changes
replace mmiss=1 if ON014>9997 & ON014<199999999;

gen exactvalue=ON014;
gen lowervalue=ON015;
gen uppervalue=ON016;

imputethis;
gen ins12_1 = exactvalue * 12;
replace ins12_1=0 if ins12_1==.; //what if ON014<9990 & ON018>4? Here ins12_1=0 in that case;

********************** impute ins12_2 using brackets ***********;

replace ON042_1 = 9970 if ON042_1==99999996;
*replacement value must be smaller than N040_1 error code but larger than its max value;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if ON040_1>-100 & ON040_1<9980; //check N040_1 error codes for changes
replace mmiss=1 if ON040_1>9990 & ON040_1<19999990;

replace exactvalue=ON040_1;
replace lowervalue=ON041_1;
replace uppervalue=ON042_1;

imputethis;
gen ins12_2 = exactvalue*12;
replace ins12_2=0 if ins12_2==.;

********************** impute ins12_3 using brackets ***********;

replace ON042_2 = 5000 if ON042_2==99999996;
*replacement value must be smaller than N040_2 error code but larger than its max value;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if ON040_2>-100 & ON040_2<9980; //check N040_2 error codes for changes
replace mmiss=1 if ON040_2>9990 & ON040_2<19999990;

replace exactvalue=ON040_2;
replace lowervalue=ON041_2;
replace uppervalue=ON042_2;

imputethis;
gen ins12_3 = exactvalue*12;
replace ins12_3=0 if ins12_3==.;

********************** impute ins12_4 using brackets ***********;
replace ON042_3 = 1000 if ON042_3==99999996;
*replacement value must be smaller than N040_3 error code but larger than its max value;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if ON040_3>-100 & ON040_3<9980; //check N040_3 error codes for changes
replace mmiss=1 if ON040_3>9990 & ON040_3<19999990;

replace exactvalue=ON040_3;
replace lowervalue=ON041_3;
replace uppervalue=ON042_3;

imputethis;
gen ins12_4 = exactvalue*12;
replace ins12_4=0 if ins12_4==.;

********************** impute ins12_5 using brackets ***********;

*set N079 to monthly values for imputation purposes, since N015 and N016 are monthly;
replace ON079 = ON079/3 if ON083 == 2;
replace ON079 = ON079/12 if ON083 == 4;
replace ON079 = ON079*4 if ON083==3;
replace ON079 = . if ON083>4 & ON083~=.;

replace ON081=100001 if ON081==99999996;
*replacement value must be smaller than N040_3 error code but larger than its max value;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if ON079>-100 & ON079<999990; //check N079 error codes for changes
replace mmiss=1 if ON079>999990 & ON079<199999999;

replace exactvalue=ON079;
replace lowervalue=ON080;
replace uppervalue=ON081;

imputethis;
gen ins12_5 = exactvalue * 12;
replace ins12_5=0 if ins12_5==.; //what if ON079<999990 & ON083>4? Here ins12_5=0 in that case;




gen iprem12= ins12_1 + ins12_2 + ins12_3 + ins12_4 + ins12_5;

keep HHID PN ins* iprem* ON040_1*;
gen t2 = real(HHID);
drop HHID;
rename t2 HHID;
gen t2 = real(PN);
drop PN;
rename t2 PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

merge HHID PN using `saved'medcost;
drop _merge;

replace ON040_1 = . if ON040_1>9997;

*Jon: Here are generate all of the variables that would have been generated if the imputed HRS data was available.;
gen hospc12=.;
gen nursc12=.;
gen outsgc12=.;
gen docc12=.;
gen dentc12=.;
gen drugc12=.;
gen hhsc12=.;
gen othels12=.;
gen oop12=.;
gen oop12b =. ;
gen oop12c = .;


keep HHID PN medcost*  hospc* nursc* outsgc* docc* dentc* hhsc* othels* oop* drugc* tc* iprem* ins*;
*keep HHID PN oop* drugc* iprem* ins*;
*drop iprem9;
summ;
*gen medcost9a = oop9 + iprem9a + drugc9;
sort HHID PN;

*replace iprem9a=. if iprem9==.; * missings are counted as 0s in the imputation file;

gen medcost12 = oop12 + iprem12 + drugc12;

sort HHID PN;
sleep 1000; save `saved'medcost, replace; 

clear;




************* WAVE 13 **************************;



use `wave13d'H16N_R;


********************** impute ins12_1 using brackets ***********;

*set N014 to monthly values for imputation purposes, since N015 and N016 are monthly
replace PN014 = PN014/3 if PN018 == 2; 
replace PN014 = PN014/6 if PN018 == 3;
replace PN014 = PN014/12 if PN018 == 4;
replace PN014 = . if PN018>4 & PN018~=.;

replace PN016=997 if PN016==99999996;
*replacement value must be smaller than N014 error code but larger than its max value;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if PN014>-100 & PN014<998; //check N014 error codes for changes
replace mmiss=1 if PN014>997 & PN014<199999999;

gen exactvalue=PN014;
gen lowervalue=PN015;
gen uppervalue=PN016;

imputethis;
gen ins13_1 = exactvalue * 12;
replace ins13_1=0 if ins13_1==.; //what if PN014<9990 & PN018>4? Here ins13_1=0 in that case;

********************** impute ins12_2 using brackets ***********;

replace PN042_1 = 9997 if PN042_1==99999996;
*replacement value must be smaller than N040_1 error code but larger than its max value;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if PN040_1>-100 & PN040_1<9998; //check N040_1 error codes for changes
replace mmiss=1 if PN040_1>9997 & PN040_1<199999990;

replace exactvalue=PN040_1;
replace lowervalue=PN041_1;
replace uppervalue=PN042_1;

imputethis;
gen ins13_2 = exactvalue*12;
replace ins13_2=0 if ins13_2==.;

********************** impute ins13_3 using brackets ***********;

replace PN042_2 = 9997 if PN042_2==99999996;
*replacement value must be smaller than N040_2 error code but larger than its max value;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if PN040_2>-100 & PN040_2<9998; //check N040_2 error codes for changes
replace mmiss=1 if PN040_2>9997 & PN040_2<199999990;

replace exactvalue=PN040_2;
replace lowervalue=PN041_2;
replace uppervalue=PN042_2;

imputethis;
gen ins13_3 = exactvalue*12;
replace ins13_3=0 if ins13_3==.;

********************** impute ins13_4 using brackets ***********;
replace PN042_3 = 9970 if PN042_3==99999996; 
*replacement value must be smaller than N040_3 error code but larger than its max value;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if PN040_3>-100 & PN040_3<9980; //check N040_3 error codes for changes
replace mmiss=1 if PN040_3>9980 & PN040_3<19999990;

replace exactvalue=PN040_3;
replace lowervalue=PN041_3;
replace uppervalue=PN042_3;

imputethis;
gen ins13_4 = exactvalue*12;
replace ins13_4=0 if ins13_4==.;

********************** impute ins13_5 using brackets ***********;

*set N079 to monthly values for imputation purposes, since N015 and N016 are monthly;
replace PN079 = PN079/3 if PN083 == 2;
replace PN079 = PN079/12 if PN083 == 4;
*replace PN079 = PN079*4 if PN083==3;
replace PN079 = . if PN083>4 & PN083~=.;

replace PN081=999000 if PN081==99999996; 
*replacement value must be smaller than N040_3 error code but larger than its max value;
*check above-breakpoint code;

gen mmiss=.; 
replace mmiss=0 if PN079>-100 & PN079<999990; //check N079 error codes for changes
replace mmiss=1 if PN079>999990 & PN079<199999999;

replace exactvalue=PN079;
replace lowervalue=PN080;
replace uppervalue=PN081;

imputethis;
gen ins13_5 = exactvalue * 12;
replace ins13_5=0 if ins13_5==.; //what if PN079<999990 & PN083>4? Here ins13_5=0 in that case;




gen iprem13= ins13_1 + ins13_2 + ins13_3 + ins13_4 + ins13_5;

keep HHID PN ins* iprem* PN040_1*;
gen t2 = real(HHID);
drop HHID;
rename t2 HHID;
gen t2 = real(PN);
drop PN;
rename t2 PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

merge HHID PN using `saved'medcost;
drop _merge;

replace PN040_1 = . if PN040_1>9997;

*Jon: Here are generate all of the variables that would have been generated if the imputed HRS data was available.;
gen hospc13=.;
gen nursc13=.;
gen outsgc13=.;
gen docc13=.;
gen dentc13=.;
gen drugc13=.;
gen hhsc13=.;
gen othels13=.;
gen oop13=.;
gen oop13b =. ;
gen oop13c = .;


keep HHID PN medcost*  hospc* nursc* outsgc* docc* dentc* hhsc* othels* oop* drugc* tc* iprem* ins*;
*keep HHID PN oop* drugc* iprem* ins*;
summ;
sort HHID PN;

gen medcost13 = oop13 + iprem13 + drugc13;

sort HHID PN;
sleep 1000; save `saved'medcost, replace; 

clear;
************* END WAVE 13 **************************;


************* WAVE 14 **************************;

use `wave14d'H18N_R;
rename hhid HHID;
rename pn PN;
********************** impute ins12_1 using brackets ***********;
* QN014 and others in Wave 14
* now have  -8.  Web non-response 
*set N014 to monthly values for imputation purposes, since N015 and N016 are monthly
replace QN014 = QN014/3 if QN018 == 2; 
replace QN014 = QN014/6 if QN018 == 3;
replace QN014 = QN014/12 if QN018 == 4;
replace QN014 = . if QN018>4 & QN018~=.;

replace QN016=99997 if QN016==99999996;
*replacement value must be smaller than N014 error code but larger than its max value. Chris changed;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if QN014>-1 & QN014<99998  ; //check N014 error codes for changes. Chris changed
replace mmiss=1 if QN014>=99998 & QN014<199999999;
replace mmiss=1 if QN014<-1;  // to handle -8.  Web non-response 

gen exactvalue=QN014;
gen lowervalue=QN015;
gen uppervalue=QN016;

imputethis;
gen ins14_1 = exactvalue * 12;
replace ins14_1=0 if ins14_1==.; //what if QN014<9990 & QN018>4? Here ins14_1=0 in that case;

********************** impute ins12_2 using brackets ***********;

replace QN042_1 = 9997 if QN042_1==99999996;
*replacement value must be smaller than N040_1 error code but larger than its max value. Chris Ok; 
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if QN040_1>-1 & QN040_1<9998; //check N040_1 error codes for changes. Chris Ok
replace mmiss=1 if QN040_1>9997 & QN040_1<199999990;
replace mmiss=1 if QN040_1<-1;  // to handle -8.  Web non-response 
replace exactvalue=QN040_1;
replace lowervalue=QN041_1;
replace uppervalue=QN042_1;

imputethis;
gen ins14_2 = exactvalue*12;
replace ins14_2=0 if ins14_2==.;

********************** impute ins14_3 using brackets ***********;

replace QN042_2 = 9997 if QN042_2==99999996;
*replacement value must be smaller than N040_2 error code but larger than its max value;
*check above-breakpoint code. Chris OK;

gen mmiss=.;
replace mmiss=0 if QN040_2>-1 & QN040_2<9998; //check N040_2 error codes for changes. Chris Ok
replace mmiss=1 if QN040_2>9997 & QN040_2<199999990;
replace mmiss=1 if QN040_2<-1;  // to handle -8.  Web non-response 
replace exactvalue=QN040_2;
replace lowervalue=QN041_2;
replace uppervalue=QN042_2;

imputethis;
gen ins14_3 = exactvalue*12;
replace ins14_3=0 if ins14_3==.;

********************** impute ins14_4 using brackets ***********;
replace QN042_3 = 997 if QN042_3==99999996; 
*replacement value must be smaller than N040_3 error code but larger than its max value;
*check above-breakpoint code. Chris changed;

gen mmiss=.;
replace mmiss=0 if QN040_3>-1 & QN040_3<998; //check N040_3 error codes for changes. Chris changed.
replace mmiss=1 if QN040_3>997 & QN040_3<19999990;
replace mmiss=1 if QN040_3<-1;  // to handle -8.  Web non-response 

replace exactvalue=QN040_3;
replace lowervalue=QN041_3;
replace uppervalue=QN042_3;

imputethis;
gen ins14_4 = exactvalue*12;
replace ins14_4=0 if ins14_4==.;

********************** impute ins14_5 using brackets ***********;

*set N079 to monthly values for imputation purposes, since N015 and N016 are monthly;
replace QN079 = QN079/3 if QN083 == 2;
replace QN079 = QN079/12 if QN083 == 4;
*replace QN079 = QN079*4 if QN083==3;
replace QN079 = . if QN083>4 & QN083~=.;

replace QN081=999000 if QN081==99999996; 
*replacement value must be smaller than N040_3 error code but larger than its max value. Chris OK;
*check above-breakpoint code;

gen mmiss=.; 
replace mmiss=0 if QN079>-1 & QN079<999990; //check N079 error codes for changes. Chris ok
replace mmiss=1 if QN079>999990 & QN079<199999999;
replace mmiss=1 if QN079<-1;  // to handle -8.  Web non-response                                          
replace exactvalue=QN079;
replace lowervalue=QN080;
replace uppervalue=QN081;

imputethis;
gen ins14_5 = exactvalue * 12;
replace ins14_5=0 if ins14_5==.; //what if QN079<999990 & QN083>4? Here ins14_5=0 in that case;




gen iprem14= ins14_1 + ins14_2 + ins14_3 + ins14_4 + ins14_5;

keep HHID PN ins* iprem* QN040_1*;
gen t2 = real(HHID);
drop HHID;
rename t2 HHID;
gen t2 = real(PN);
drop PN;
rename t2 PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

merge HHID PN using `saved'medcost;
drop _merge;

* Chris: should this be changed to 9997 ?; 
replace QN040_1 = . if QN040_1>9997;

*Jon: Here are generate all of the variables that would have been generated if the imputed HRS data was available.;
gen hospc14=.;
gen nursc14=.;
gen outsgc14=.;
gen docc14=.;
gen dentc14=.;
gen drugc14=.;
gen hhsc14=.;
gen othels14=.;
gen oop14=.;
gen oop14b =. ;
gen oop14c = .;


keep HHID PN medcost*  hospc* nursc* outsgc* docc* dentc* hhsc* othels* oop* drugc* tc* iprem* ins*;
*keep HHID PN oop* drugc* iprem* ins*;
summ;
sort HHID PN;

gen medcost14 = oop14 + iprem14 + drugc14;

sort HHID PN;
sleep 1000; save `saved'medcost, replace; 

clear;

************* END WAVE 14 **************************;



************* WAVE 15 **************************;
if $INCLUDE2020 {; 
disp "Doing 2020 processing..." ;
use `wave15d'H20N_R;
rename hhid HHID;
rename pn PN;
********************** impute ins12_1 using brackets ***********;
* RN014 and others in Wave 15
* now have  -8.  Web non-response 
*set N014 to monthly values for imputation purposes, since N014 and N016 are monthly
replace RN014 = RN014/3 if RN018 == 2; 
replace RN014 = RN014/6 if RN018 == 3;
replace RN014 = RN014/12 if RN018 == 4;
replace RN014 = . if RN018>4 & RN018~=.;

replace RN016=99997 if RN016==99999996;
*replacement value must be smaller than N014 error code but larger than its max value. Chris changed;
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if RN014>-1 & RN014<99998  ; //check N014 error codes for changes. Chris changed
replace mmiss=1 if RN014>=99998 & RN014<199999999;
replace mmiss=1 if RN014<-1;  // to handle -8.  Web non-response 

gen exactvalue=RN014;
gen lowervalue=RN014;
gen uppervalue=RN016;

imputethis;
gen ins15_1 = exactvalue * 12;
replace ins15_1=0 if ins15_1==.; //what if RN014<9990 & RN018>4? Here ins15_1=0 in that case;

********************** impute ins12_2 using brackets ***********;

replace RN042_1 = 9997 if RN042_1==99999996;
*replacement value must be smaller than N040_1 error code but larger than its max value. Chris Ok; 
*check above-breakpoint code;

gen mmiss=.;
replace mmiss=0 if RN040_1>-1 & RN040_1<9998; //check N040_1 error codes for changes. Chris Ok
replace mmiss=1 if RN040_1>9997 & RN040_1<199999990;
replace mmiss=1 if RN040_1<-1;  // to handle -8.  Web non-response 
replace exactvalue=RN040_1;
replace lowervalue=RN041_1;
replace uppervalue=RN042_1;

imputethis;
gen ins15_2 = exactvalue*12;
replace ins15_2=0 if ins15_2==.;

********************** impute ins15_3 using brackets ***********;

replace RN042_2 = 9997 if RN042_2==99999996;
*replacement value must be smaller than N040_2 error code but larger than its max value;
*check above-breakpoint code. Chris OK;

gen mmiss=.;
replace mmiss=0 if RN040_2>-1 & RN040_2<9998; //check N040_2 error codes for changes. Chris Ok
replace mmiss=1 if RN040_2>9997 & RN040_2<199999990;
replace mmiss=1 if RN040_2<-1;  // to handle -8.  Web non-response 
replace exactvalue=RN040_2;
replace lowervalue=RN041_2;
replace uppervalue=RN042_2;

imputethis;
gen ins15_3 = exactvalue*12;
replace ins15_3=0 if ins15_3==.;

********************** impute ins15_4 using brackets ***********;
replace RN042_3 = 997 if RN042_3==99999996; 
*replacement value must be smaller than N040_3 error code but larger than its max value;
*check above-breakpoint code. Chris changed;

gen mmiss=.;
replace mmiss=0 if RN040_3>-1 & RN040_3<998; //check N040_3 error codes for changes. Chris changed.
replace mmiss=1 if RN040_3>997 & RN040_3<19999990;
replace mmiss=1 if RN040_3<-1;  // to handle -8.  Web non-response 

replace exactvalue=RN040_3;
replace lowervalue=RN041_3;
replace uppervalue=RN042_3;

imputethis;
gen ins15_4 = exactvalue*12;
replace ins15_4=0 if ins15_4==.;

********************** impute ins15_5 using brackets ***********;

*set N079 to monthly values for imputation purposes, since N014 and N016 are monthly;
replace RN079 = RN079/3 if RN083 == 2;
replace RN079 = RN079/12 if RN083 == 4;
*replace RN079 = RN079*4 if RN083==3;
replace RN079 = . if RN083>4 & RN083~=.;

replace RN081=999000 if RN081==99999996; 
*replacement value must be smaller than N040_3 error code but larger than its max value. Chris OK;
*check above-breakpoint code;

gen mmiss=.; 
replace mmiss=0 if RN079>-1 & RN079<999990; //check N079 error codes for changes. Chris ok
replace mmiss=1 if RN079>999990 & RN079<199999999;
replace mmiss=1 if RN079<-1;  // to handle -8.  Web non-response                                          
replace exactvalue=RN079;
replace lowervalue=RN080;
replace uppervalue=RN081;

imputethis;
gen ins15_5 = exactvalue * 12;
replace ins15_5=0 if ins15_5==.; //what if RN079<999990 & RN083>4? Here ins15_5=0 in that case;




gen iprem15= ins15_1 + ins15_2 + ins15_3 + ins15_4 + ins15_5;

keep HHID PN ins* iprem* RN040_1*;
gen t2 = real(HHID);
drop HHID;
rename t2 HHID;
gen t2 = real(PN);
drop PN;
rename t2 PN;
sort HHID PN;
sleep 1000; save `saved'temp, replace;

merge HHID PN using `saved'medcost;
drop _merge;

* Chris: should this be changed to 9997 ?; 
replace RN040_1 = . if RN040_1>997;

*Jon: Here are generate all of the variables that would have been generated if the imputed HRS data was available.;
gen hospc15=.;
gen nursc15=.;
gen outsgc15=.;
gen docc15=.;
gen dentc15=.;
gen drugc15=.;
gen hhsc15=.;
gen othels15=.;
gen oop15=.;
gen oop15b =. ;
gen oop15c = .;


keep HHID PN medcost*  hospc* nursc* outsgc* docc* dentc* hhsc* othels* oop* drugc* tc* iprem* ins*;
*keep HHID PN oop* drugc* iprem* ins*;
summ;
sort HHID PN;

gen medcost15 = oop15 + iprem15 + drugc15;

sort HHID PN;
sleep 1000; save `saved'medcost, replace; 

clear;

};
************* END WAVE 15 **************************;

************ AHEAD WAVE I ****************;

*** NOTE THAT bhh21 is HOUSEHOLD LEVEL *****;
use `aheadw1'bhh21;

renpfix V v;

* impute v629X;
replace v629X=0 if v622==5; * "no" for v622;
replace v629X=. if v622==.; * DK, RF and NA;
replace v629X=0 if v627==5; * "no" for v627;
replace v629X=. if v627==7; * costs not settled yet;
replace v629X=. if v627==. & v622~=5; * DK, RF and NA;
replace v629X=0 if v628==5;
replace v629X=. if v628==. & v622~=5 & v627~=5 & v627~=7; 

* Li's question?????: I don't know if I should let the above case have missing value or 0 value.  I will just let it be missing values;


* v740X includes all non-nursing home expenses (ie oop1+drugc1);
gen oop1=v629X+v740X;


********* contribution made by children or other ****;
* impute v749;
replace v749=0 if v746==5;
replace v749=0 if v746==. & v740X~=.; * This command will convert 10 DK of v746 into 0, which we like, and at the same time convert 4 RF of v746 into 0, which we don't like;
replace v749=0 if v747==2|v747==3;
gen kidcont1=v749;



gen tc1=.;
gen drugc1=.; * drug costs are in v740X, so we don't know how much it is;   


keep HHID BSUBHH oop1 tc1 drugc1 kidcont1;
summ;
sort HHID BSUBHH;
sleep 500; save `aheadw1'medcost, replace;

********* WAVE I AHEAD INSURANCE ************;
use `aheadw1'br21;

renpfix V v;
* impute v1867;
replace v1867=0 if v1859==5;
replace v1867=0 if v1859==. & v1848~=.; * This command will convert 16 DK of v1849 into 0, which we like, and at the same time convert 6 RF of v1849 into 0, which we don't like;
replace v1867=. if v1859==1 & v1868==.; * qualifiers confirmed: for those applicable to v1867(where v1849==1), but v1868==.;
* there are three maga-outliers that I drop;
replace v1867=. if v1867~=. & v1867>10000 & (v1868==1|v1868==2|v1868==3|v1868==4);

replace v1867=v1867*52 if v1868==1;
replace v1867=v1867*6 if v1868==2; 
* Li's question ????????????: Note: Here I don't understand " 2 x month". I take it as 2 month;

replace v1867=v1867*12 if v1868==3;
replace v1867=v1867*4 if v1868==4;
replace v1867=v1867*2 if v1868==5;
replace v1867=v1867*6 if v1868==8;
replace v1867=. if v1868==7; * "other SPECIFY" re-coded as missing;
rename v1867 iprem1;
gen insa1_1=iprem1;
keep HHID BSUBHH PN iprem1 ins*;
summ;
sort HHID BSUBHH;
merge HHID BSUBHH using `aheadw1'medcost;
drop _merge;
drop BSUBHH;


* sum up the medical cost for wave 1 now;****************************************;
* Recall that oop1 is a family level variable ;
* Does this mean that I need to fix the variable somehow ?;
**********************************************************;
destring PN, replace;
destring HHID, replace;
egen hhnum=count(PN), by (HHID);
sum hhnum;
replace oop1=oop1/2 if hhnum==2; * in all other waves, medical expenses are your own medical expenses, in this wave it is family medical expesese, so divide by 2 for families;
gen medcost1=iprem1+oop1; * since drugc1 is included in oop1, so we don't need to write medcost1=iprem1+oop1+drugc1, so please treat the oop1 and drugc1 in this wave differently from other waves;
*replace oop1=.;
replace drugc1=.;



summ;

sort HHID PN;
sleep 500; save `aheadw1'medcost, replace;
drop _all;
*bomb;
* Note: no other variables available for WAVE I AHEAD.;
**************** AHEAD WAVE II *******************;
use `aheadw2'A95cs_r; * get some CS variable from this file;
keep HHID PN D240;
sort HHID PN;
sleep 500; save `aheadw2'temp2, replace;


use `aheadw2'a95i_er;
sort HHID PN;
merge HHID PN using `aheadw2'temp2;
drop _merge;

***OOP Annual Expenses******;
gen hospc2=D1688X/2; *imputed oop hospital/nursing home costs;
gen docc2=D1732X/2; *imputed oop doctor/outpatient/dentist visits costs;
gen drugc2=(D1749X*12)/2; *imputed oop rX drug costs;
gen othels2=D1781X/2; *imputed oop amt. other health services;

gen oop2=hospc2+docc2+othels2;
gen tc2=.;

gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;

keep HHID DSUBHH PN hospc* docc* drugc* othels* tc2 oop2;
summ;
sort HHID PN;
sleep 500; save `aheadw2'medcost, replace;
*bomb;


**************** WAVE II AHEAD INSURANCE *****************; 
use `aheadw2'A95pr_r;
keep D126 HHID PN;
sort HHID PN;
sleep 500; save `aheadw2'temp2, replace;

use `aheadw2'A95r_r;
sort HHID PN;
merge HHID PN using `aheadw2'temp2;
drop _merge;

* cost for Medicare insurance through HMO;
* impute D5193;
replace D5193=0 if D126~=1 & (D5144==5|D5144==7|D5144==8|D5144==.) & 
(D5176==1|D5176==2|D5176==5|D5176==11|D5176==21|D5176==22|
D5176==97|D5175==5|D5175==8); * qualifiers confirmed;
*  I don't how to interpret D126~=1, it just means that wave1 
information is not available, either because the wave1 respondent refused or 
because the wave 2 respondent is new. I think the re-coding is correct;

replace D5193=0 if D5183==5|D5183==7|D5183==8; * qualifiers checked right.;
replace D5193=. if D5183==9;
replace D5193=. if D5193>99996|(D5194>3 & D5194~=.);
*************************************
comment: Here I let "per other" to "per  ???" be missing, since we don't know if it is "per two weeks" or "per two years". ;

replace D5193=D5193*24 if D5194==1; * Two year variable first;
replace D5193=D5193*8 if D5194==2;
replace D5193=D5193*2 if D5194==3;

gen insa2_1=D5193;

* cost for employer provided HMO-1;
* impute D5227;
sum D5193 D5227;
* replace D5227=0 if D5214==5|D5214==8|D5214==.|D5215==0|(D5226==2 & D5227==.); * qualifiers confirmed;

replace D5227=. if D5227>99996|(D5228>3 & D5228~=.);

*************************************
comment: Here I let "per other" to "per  ???" be missing, since we don't know if it is "per two weeks" or "per two years". ;
replace D5227=D5227*24 if D5228==1; * Two year variable first;
replace D5227=D5227*8 if D5228==2;
replace D5227=D5227*2 if D5228==3;

sum D5193 D5227;
/* NOTE THE PROBLEM AND FIX BELOW */
/*>At the beginning of the AHEAD wave 2 field period there was a programming
>error in the skip logic.  Persons who reported only one plan at D5215 were
>skipped ahead to Q5230 and not asked about that plan.  There were 1,174
>respondents who answered "1" to D5215 and should have been asked D522M1 but
>were not. Q5230 was not a real question, it was just a marker in the
>program. This was fixed during the field period, so later interviews were
>processed correctly.  The codebook for D5225M1 describes this, albeit in
>quite opaque terms. */
* the fix;
replace D5227=. if D5227>30000;
sort D5215;
by D5215: sum D5215 D5227;
egen D5227j=mean(D5227);
replace D5227j=D5227j*(1200/2000); * 2000 missings, only 1200 should be missings;
replace D5227=D5227j if D5227==. & D5215==1;
by D5215: sum D5215 D5227;



gen insa2_2=D5227;

* cost for employer provided HMO-2;
* impute D5244;
replace D5244=0 if D5214==5|D5214==8|D5215==0|D5215==1|D5243==2; * qualifiers confirmed;
replace D5244=. if D5244>99996|(D5245>3 & D5245~=.);
*************************************
comment: Here I let "per other" to "per  ???" be missing, since we don't know if it is "per two weeks" or "per two years".; 
replace D5244=D5244*24 if D5245==1; * Two year variable first;
replace D5244=D5244*8 if D5245==2;
replace D5244=D5244*2 if D5245==3;

gen insa2_3=D5244;



**************** 2 observations with long-term care insurance , while we don't know where such insurance come from ***********************;

* cost for long-term (L-T) insurance plan;
* impute D5267;
replace D5267=0 if D5263==5|D5263==8; * qualifiers confirmed;
replace D5267=. if D5267>99996|(D5268>3 & D5268~=.);
*************************************
comment: Here I let "per other" to "per  ???" be missing, since we don't know if it is "per two weeks" or "per two years". ;
replace D5267=D5267*24 if D5268==1; * Two year variable first;
replace D5267=D5267*8 if D5268==2;
replace D5267=D5267*2 if D5268==3;

gen insa2_4=D5267;

* total insurance cost: iprem2;
replace D5193 = 0 if D5193 == .;
replace D5227 = 0 if D5227 == .;
replace D5244 = 0 if D5244 == .;
replace D5267 = 0 if D5267 == .;

gen iprem2=(D5193+D5227+D5244+D5267)/2;
gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN; 
keep HHID DSUBHH PN iprem2 ins*;
summ; 

keep HHID DSUBHH PN iprem2 ins*;
sort HHID PN;
merge HHID PN using `aheadw2'medcost;
drop _merge;
summ;
gen medcost2=iprem2+oop2+drugc2;



summ;
sort HHID PN;
merge HHID PN using `aheadw1'medcost;
drop _merge; 



* rename AHEAD variables for merging;
rename oop1 aoop1;
rename drugc1 adrugc1;
rename tc1 atc1;
rename iprem1 aiprem1;
rename medcost1 amedcos1;
rename oop2 aoop2;
rename drugc2 adrugc2;
rename tc2 atc2;
rename iprem2 aiprem2;
rename medcost2 amedcos2;


summ;
sort HHID PN;
sleep 500; save `aheadw2'medcost, replace; 
drop _all;




*************** merge AHEAD data to HRS data ******************;
* merge the AHEAD medcost.dta file to the HRS medcost.dta file here;

use `saved'medcost;
*gen temp=real(HHID);
*drop HHID;
*rename temp HHID;
*gen temp=real(PN);
*drop PN;
*rename temp PN; 

sort HHID PN;
merge HHID PN using `aheadw2'medcost;
drop _merge;

sum ai* ao* amed* i* med*;

* replace missing HRS WAVE I and WAVE II values with AHEAD WAVE I and WAVE II 
values;

replace oop1=aoop1 if oop1==. & aoop1~=.;
replace drugc1=adrugc1 if drugc1==. & adrugc1~=.;
replace tc1=atc1 if tc1==. & atc1~=.;
replace iprem1=aiprem1 if iprem1==. & aiprem1~=.;
replace medcost1=amedcos1 if medcost1==. & amedcos1~=.;

summ oop2;

replace oop2=aoop2 if oop2==. & aoop2~=.;
replace drugc2=adrugc2 if drugc2==. & adrugc2~=.;
replace tc2=atc2 if tc2==. & atc2~=.;
replace iprem2=aiprem2 if iprem2==. & aiprem2~=.;
replace medcost2=amedcos2 if medcost2==. & amedcos2~=.;

sum oop2;

drop a*; * drop AHEAD variables;


* from June 07;
* this is important **************************;
* there exists both medcost6 and medcost6a, medcost7 and medcost7a;
* the "a" version is where the HRS does the imputations                  ;
* currently, the hrs imputations for wave 7 are screwed up, so that we do not use them;
* however, we believe that the HRS wave 6 imputations are OK, so we use them    ;

replace medcost6=medcost6a;
*medcare & hmo
gen medhmo1=.;
gen medhmo2=insa2_1;
gen medhmo3=ins3_1;
gen medhmo4=ins4_1;
gen medhmo5=ins5_1;
gen medhmo6=ins6_1;
gen medhmo7=ins7_1;
gen medhmo8=ins8_1;
gen medhmo9=ins9_1;
gen medhmo10=ins10_1;
gen medhmo11=ins11_1;
gen medhmo12=ins12_1;
gen medhmo13=ins13_1;
gen medhmo14=ins14_1;

*Jon: I make the disaggregated medcost variables the same across waves here;

gen hospc1 = .;
gen docc1= .;
gen othels1=.;
gen dentc1=.;
gen nursc1=.;
gen outsgc1=.;
gen hhsc1=.;

replace hospc2 = .;
replace docc2= .;
replace othels2=.;
gen dentc2=.;
gen nursc2=.;
gen outsgc2=.;
gen hhsc2=.;

replace hospc3 = .;
replace docc3= .;
replace othels3=.;
gen dentc3=.;
gen nursc3=.;
gen outsgc3=.;
gen hhsc3=.;

replace hospc4 = .;
replace docc4= .;
replace othels4=.;
gen dentc4=.;
gen nursc4=.;
gen outsgc4=.;
gen hhsc4=.;

replace hospc5 = .;
replace docc5= .;
replace othels5=.;
gen dentc5=.;
gen nursc5=.;
gen outsgc5=.;
gen hhsc5=.;

aorder;

sort HHID PN;
sleep 1000; save `saved'medcost, replace;

cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(medcost.xlsx) replace;
cd "$folder\hrs\merge\" ;
use `saved'medcost.old.dta , clear;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(medcost.xlsx) sheetname(Old);




*drop docc2 hhnum hospc2 insa* kidcont1 othels2; *Jon: I change this to keep docc2, hospc2 and othels2;
drop hhnum insa* kidcont1 ;
summ;
*drop _all;
cap log close;
